﻿################################################################################
## Initialization
################################################################################

init offset = -1


################################################################################
## Styles
################################################################################

style default:
    properties gui.text_properties()
    language gui.language

style input:
    properties gui.text_properties("input", accent=True)
    adjust_spacing False

style hyperlink_text:
    properties gui.text_properties("hyperlink", accent=True)
    hover_underline True

style gui_text:
    properties gui.text_properties("interface")


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.text_properties("button")
    yalign 0.5


style label_text is gui_text:
    properties gui.text_properties("label", accent=True)

style prompt_text is gui_text:
    properties gui.text_properties("prompt")


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)



################################################################################
## In-game screens
################################################################################


## Say screen ##################################################################
##
## The say screen is used to display dialogue to the player. It takes two
## parameters, who and what, which are the name of the speaking character and
## the text to be displayed, respectively. (The who parameter can be None if no
## name is given.)
##
## This screen must create a text displayable with id "what", as Ren'Py uses
## this to manage text display. It can also create displayables with id "who"
## and id "window" to apply style properties.
##
## https://www.renpy.org/doc/html/screen_special.html#say

screen say(who, what):
    style_prefix "say"

    window:
        id "window"

        if who is not None:

            window:
                id "namebox"
                style "namebox"
                text who id "who"

        text what id "what"


    ## If there's a side image, display it above the text. Do not display on the
    ## phone variant - there's no room.
    if not renpy.variant("small"):
        add SideImage() xalign 0.0 yalign 1.0


## Make the namebox available for styling through the Character object.
init python:
    config.character_id_prefixes.append('namebox')

style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height

    background Image("gui/textbox.png", xalign=0.5, yalign=1.0)

style namebox:
    xpos gui.name_xpos
    xanchor gui.name_xalign
    xsize gui.namebox_width
    ypos gui.name_ypos
    ysize gui.namebox_height

    background Frame("gui/namebox.png", gui.namebox_borders, tile=gui.namebox_tile, xalign=gui.name_xalign)
    padding gui.namebox_borders.padding

style say_label:
    outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
    color "#FFFFFF"

    properties gui.text_properties("name", accent=True)
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
    color "#FFFFFF"

    properties gui.text_properties("dialogue")

    xpos gui.dialogue_xpos
    xsize gui.dialogue_width
    ypos gui.dialogue_ypos


## Input screen ################################################################
##
## This screen is used to display renpy.input. The prompt parameter is used to
## pass a text prompt in.
##
## This screen must create an input displayable with id "input" to accept the
## various input parameters.
##
## https://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):
    style_prefix "input"

    window:

        vbox:
            xalign gui.dialogue_text_xalign
            xpos gui.dialogue_xpos
            xsize gui.dialogue_width
            ypos gui.dialogue_ypos

            text prompt style "input_prompt"
            input id "input"

style input_prompt is default

style input_prompt:
    xalign gui.dialogue_text_xalign
    properties gui.text_properties("input_prompt")

style input:
    xalign gui.dialogue_text_xalign
    xmaximum gui.dialogue_width


## Choice screen ###############################################################
##
## This screen is used to display the in-game choices presented by the m
## statement. The one parameter, items, is a list of objects, each with caption
## and action fields.
##
## https://www.renpy.org/doc/html/screen_special.html#choice

define gui.choice_button_text_idle_color = '#FFFFFF'
define gui.choice_text_hovor_color = '#e862f6'

screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            textbutton i.caption action i.action
###For Android Builds v
#            textbutton i.caption:
#                action i.action
#                background "gui/button/choice_idle_background.png"
#                hover_background "gui/button/choice_hover_background.png"





## When this is true, m captions will be spoken by the narrator. When false,
## menu captions will be displayed as empty buttons.
define config.narrator_menu = True


style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    ypos 405
    yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.button_text_properties("choice_button")


## Quick Menu screen ###########################################################
##
## The quick menu is displayed in-game to provide easy access to the out-of-game
## menus.

screen quick_menu():

    ## Ensure this appears on top of other screens.
    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 0.990

            textbutton _("Back") action Rollback()
            textbutton _("History") action ShowMenu('history')
            textbutton _("Skip") action Skip() alternate Skip(fast=True, confirm=True)
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Save") action ShowMenu('save')
            textbutton _("Q.Save") action QuickSave()
            textbutton _("Q.Load") action QuickLoad()
            textbutton _("Prefs") action ShowMenu('preferences')


## This code ensures that the quick_menu screen is displayed in-game, whenever
## the player has not explicitly hidden the interface.
init python:
    config.overlay_screens.append("quick_menu")

default quick_menu = True

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.button_text_properties("quick_button")


################################################################################
## Main and Game Menu Screens
################################################################################

## Navigation screen ###########################################################
##
## This screen is included in the main and game menus, and provides navigation
## to other menus, and to start the game.


screen navigation():

    vbox:
        style_prefix "navigation"

        xpos gui.navigation_xpos
        yalign 0.5

        spacing gui.navigation_spacing

        if main_menu:

            textbutton _("New Game") action Start()


        else:

            textbutton _("History") action ShowMenu("history")

            textbutton _("Save") action ShowMenu("save")

        textbutton _("Load") action ShowMenu("load")

        textbutton _("Options") action ShowMenu("preferences")

        textbutton _("{color=#FF6B2B}Patreon{/color}") action ShowMenu ("patreon")


        if _in_replay:

            textbutton _("End Replay") action EndReplay(confirm=True)

        elif not main_menu:
            textbutton _("Gallery") action ShowMenu("gallery")

            textbutton _("Main Menu") action MainMenu()


        textbutton _("Info") action ShowMenu("about")

        if renpy.variant("pc"):

            ## Help isn't necessary or relevant to mobile devices.
            ############textbutton _("Help") action ShowMenu("help")

            ## The quit button is banned on iOS and unnecessary on Android.
            textbutton _("Quit") action Quit(confirm=not main_menu)

style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.button_text_properties("navigation_button")


## Main Menu screen ############################################################
##
## Used to display the main menu when Ren'Py starts.
##
## https://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():


    ## This ensures that any other menu screen is replaced.
    tag menu



    style_prefix "main_menu"
    #volume here
    $renpy.music.set_volume(0.2, 0, 'music')
    add gui.main_menu_background

    ## This empty frame darkens the main menu.
    frame:
        pass

    ## The use statement includes another screen inside this one. The actual
    ## contents of the main menu are in the navigation screen.
    #use navigation

    if gui.show_name:

        vbox:
            xalign 0.03 ypos 125
            text "{size=55}[config.name!t]{/size}":
                style "main_menu_title"
        vbox:
            xalign 0.03 ypos 165
            text "[config.version]":
                style "main_menu_version"

    imagebutton auto "gui/button/startbtn_%s.png":
        xpos 750
        ypos 730
        focus_mask True
        action Start()

    imagebutton auto "gui/button/contbtn_%s.png":
        xpos 750
        ypos 802
        focus_mask True
        action ShowMenu("load")

    imagebutton auto "gui/button/optbtn_%s.png":
        xpos 750
        ypos 874
        focus_mask True
        action ShowMenu("preferences")

    imagebutton auto "gui/button/patbtn_%s.png":
        xpos 35
        ypos 900
        focus_mask True
        action ShowMenu ("patreon")

    if renpy.variant("pc"):

        imagebutton auto "gui/button/quitbtn_%s.png":
            xpos 750
            ypos 946
            focus_mask True
            action Quit(confirm=not main_menu)


style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    xsize 420
    yfill True

    #background "gui/overlay/main_menu.png"

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 1.0
    yoffset -30

style main_menu_text:
    properties gui.text_properties("main_menu", accent=True)

style main_menu_title:
    properties gui.text_properties("title")

style main_menu_version:
    properties gui.text_properties("version")


## Game Menu screen ############################################################
##
## This lays out the basic common structure of a game menu screen. It's called
## with the screen title, and displays the background, title, and navigation.
##
## The scroll parameter can be None, or one of "viewport" or "vpgrid". When
## this screen is intended to be used with one or more children, which are
## transcluded (placed) inside it.

screen game_menu(title, scroll=None, yinitial=0.0):

    style_prefix "game_menu"

    if main_menu:
        add gui.main_menu_background
    else:
        add gui.game_menu_background

    frame:
        style "game_menu_outer_frame"

        hbox:

            ## Reserve space for the navigation section.
            frame:
                style "game_menu_navigation_frame"

            frame:
                style "game_menu_content_frame"

                if scroll == "viewport":

                    viewport:
                        yinitial yinitial
                        scrollbars "vertical"
                        mousewheel True
                        draggable True

                        side_yfill True

                        vbox:
                            transclude

                elif scroll == "vpgrid":

                    vpgrid:
                        cols 1
                        yinitial yinitial

                        scrollbars "vertical"
                        mousewheel True
                        draggable True

                        side_yfill True

                        transclude

                else:

                    transclude

    use navigation

    textbutton _("Return"):
        style "return_button"

        action Return()

    label title

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 45
    top_padding 180

    background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 420
    yfill True

style game_menu_content_frame:
    left_margin 60
    right_margin 30
    top_margin 15

style game_menu_viewport:
    xsize 1380

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 15

style game_menu_label:
    xpos 75
    ysize 180

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -45


## About screen ################################################################
##
## This screen gives credit and copyright information about the game and Ren'Py.
##
## There's nothing special about this screen, and hence it also serves as an
## example of how to make a custom screen.



screen gallery():
    tag menu

    use game_menu(_("Lin"), scroll="page"):

        if lin_friendship >=12:
            imagebutton auto "gui/gallerystuff/linvirgin_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("linvirgin", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

        if lin_friendship >=15:
            imagebutton auto "gui/gallerystuff/linsisgal_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("linsister", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()

        if lin_friendship >=18:
            imagebutton auto "gui/gallerystuff/lsleepgal_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("lsleep2", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()

        if lin_friendship >=19:
            imagebutton auto "gui/gallerystuff/linlibgal_%s.jpg":
                xpos 0
                ypos 256
                focus_mask True
                action Replay("linlib", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 256
                action NullAction()

        if lin_friendship >=22:
            imagebutton auto "gui/gallerystuff/lincitygal_%s.jpg":
                xpos 420
                ypos 256
                focus_mask True
                action Replay("lincity", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 256
                action NullAction()

        if lin_friendship >=23:
            imagebutton auto "gui/gallerystuff/lintraingal_%s.jpg":
                xpos 840
                ypos 256
                focus_mask True
                action Replay("ellentalklin", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 256
                action NullAction()

        if lin_friendship >=24:
            imagebutton auto "gui/gallerystuff/linfuckgal_%s.jpg":
                xpos 0
                ypos 512
                focus_mask True
                action Replay("cornwall", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 512
                action NullAction()

    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("gallery2")




screen gallery2():
    tag menu

    use game_menu(_("Kali"), scroll="page"):
        if kali_friendship >=14:
            imagebutton auto "gui/gallerystuff/kalipungal_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("kalipun", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

        if kali_friendship >=15:
            imagebutton auto "gui/gallerystuff/kalilingal_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("kalilinmaid", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()

        if kali_friendship >=17:
            imagebutton auto "gui/gallerystuff/kalugal_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("kdad", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()


        if kali_friendship >=18:
            imagebutton auto "gui/gallerystuff/kalihuggal_%s.jpg":
                xpos 0
                ypos 256
                focus_mask True
                action Replay("kalispringtext", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 256
                action NullAction()

        # if kali_friendship >=21:
        #     imagebutton auto "gui/gallerystuff/kalilucgal_%s.jpg":
        #         xpos 420
        #         ypos 256
        #         focus_mask True
        #         action Replay("lukalbeach")
        # else:
        #     imagebutton:
        #         idle "gui/gallerystuff/locked.jpg"
        #         xpos 420
        #         ypos 256
        #         action NullAction()

        if kali_friendship >=24:
            imagebutton auto "gui/gallerystuff/kalirp_%s.jpg":
                xpos 420
                ypos 256
                focus_mask True
                action Replay("kalirplay", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 256
                action NullAction()

    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery")
    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("gallery3")



screen gallery3():
    tag menu

    use game_menu(_("Ashley"), scroll="page"):
        if ash_friendship >=8:
            imagebutton auto "gui/gallerystuff/ashtopgal_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("ashtop", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

#        if ash_friendship >=17:
#            imagebutton auto "gui/gallerystuff/ashemgal_%s.jpg":
#                xpos 420
#                ypos 0
#                focus_mask True
#                action Replay("ashschool2")
#        else:
#            imagebutton:
#                idle "gui/gallerystuff/locked.jpg"
#                xpos 420
#                ypos 0
#                action NullAction()


        if ash_friendship >=18:
            imagebutton auto "gui/gallerystuff/ashtwingal_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("ashschool3", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()


        if ash_friendship >=19:
            imagebutton auto "gui/gallerystuff/ashtfuckgal_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("ashschool4", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()



        if ash_friendship >=23:
            imagebutton auto "gui/gallerystuff/ashmomgal_%s.jpg":
                xpos 0
                ypos 256
                focus_mask True
                action Replay("ashmom2", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 256
                action NullAction()

        if ash_friendship >=24:
            imagebutton auto "gui/gallerystuff/ashfuckgal_%s.jpg":
                xpos 420
                ypos 256
                focus_mask True
                action Replay("ashfuckathon", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 256
                action NullAction()

        if ash_friendship >=25:
            imagebutton auto "gui/gallerystuff/ashstressgal_%s.jpg":
                xpos 840
                ypos 256
                focus_mask True
                action Replay("ashstress", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 256
                action NullAction()

        if ash_friendship >=31:
            imagebutton auto "gui/gallerystuff/ashdown_%s.jpg":
                xpos 0
                ypos 512
                focus_mask True
                action Replay("ashdown2", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 512
                action NullAction()

    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery2")
    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("gallery4")


screen gallery4():
    tag menu

    use game_menu(_("Maria"), scroll="page"):

        if mar_friendship >=6:
            imagebutton auto "gui/gallerystuff/marashgal_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("marashlesbo", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

        if mar_friendship >=7:
            imagebutton auto "gui/gallerystuff/marcamgal_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("marcam", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()

        if mar_friendship >=12:
            imagebutton auto "gui/gallerystuff/marallgal_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("allbeach", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()

        if mar_friendship >=13:
            imagebutton auto "gui/gallerystuff/maregal_%s.jpg":
                xpos 0
                ypos 256
                focus_mask True
                action Replay("marellen", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 256
                action NullAction()

        if mar_friendship >=18:
            imagebutton auto "gui/gallerystuff/marlingal_%s.jpg":
                xpos 420
                ypos 256
                focus_mask True
                action Replay("marlinstream", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 256
                action NullAction()

        if mar_friendship >=25:
            imagebutton auto "gui/gallerystuff/marlin_%s.jpg":
                xpos 840
                ypos 256
                focus_mask True
                action Replay("marlinfuck", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 256
                action NullAction()

    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery3")
    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("gallery5")


screen gallery5():
    tag menu

    use game_menu(_("[botname]"), scroll="page"):

        if bot_friendship >=10:
            imagebutton auto "gui/gallerystuff/botmgal_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("botmar", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

        if bot_friendship >=11:
            imagebutton auto "gui/gallerystuff/botmargal_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("botmar2", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()

        if bot_friendship >=12:
            imagebutton auto "gui/gallerystuff/botmartgal_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("botmar3", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()

        if bot_friendship >=18:
            imagebutton auto "gui/gallerystuff/botfacegal_%s.jpg":
                xpos 0
                ypos 256
                focus_mask True
                action Replay("botface", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 256
                action NullAction()

        if bot_friendship >=22:
            imagebutton auto "gui/gallerystuff/botbotgal_%s.jpg":
                xpos 420
                ypos 256
                focus_mask True
                action Replay("botbeach", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 256
                action NullAction()

    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery4")
    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("gallery6")


screen gallery6():
    tag menu

    use game_menu(_("Felicity & Emma"), scroll="page"):

        if twin_friendship >=6:
            imagebutton auto "gui/gallerystuff/fel1gal_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("twinash", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

        if twin_friendship >=7:
            imagebutton auto "gui/gallerystuff/twingal_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("twindrunk", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()

        if twin_friendship >=15:
            imagebutton auto "gui/gallerystuff/tordgal_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("twintord", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()

        if twin_friendship >=14:
            imagebutton auto "gui/gallerystuff/emast_%s.jpg":
                xpos 0
                ypos 256
                focus_mask True
                action Replay("emmast", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 256
                action NullAction()

        if twin_friendship >=17:
            imagebutton auto "gui/gallerystuff/floopgal_%s.jpg":
                xpos 420
                ypos 256
                focus_mask True
                action Replay("flemma", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 256
                action NullAction()

        if twin_friendship >=19:
            imagebutton auto "gui/gallerystuff/emvir_%s.jpg":
                xpos 840
                ypos 256
                focus_mask True
                action Replay("emvir2", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 256
                action NullAction()

    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery5")
    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("gallery7")



screen gallery7():
    tag menu

    use game_menu(_("Autumn"), scroll="page"):

        if aut_friendship >=13:
            imagebutton auto "gui/gallerystuff/autdream_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("autdream", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()


    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery6")
    imagebutton xpos 1585 ypos 947:
        idle "gui/nextgal.png"
        hover "gui/nextgal_hover.png"
        action ShowMenu("galleryside")

screen galleryside():
    tag menu

    use game_menu(_("Others"), scroll="page"):

        if lucy_friendship >=1:
            imagebutton auto "gui/gallerystuff/luspa_%s.jpg":
                xpos 0
                ypos 0
                focus_mask True
                action Replay("lucall", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 0
                ypos 0
                action NullAction()

        if moonfuck == True:
            imagebutton auto "gui/gallerystuff/moonfuck_%s.jpg":
                xpos 420
                ypos 0
                focus_mask True
                action Replay("moonfuck", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 420
                ypos 0
                action NullAction()

        if felashbar == True:
            imagebutton auto "gui/gallerystuff/felabar_%s.jpg":
                xpos 840
                ypos 0
                focus_mask True
                action Replay("felashcomp", locked=False)
        else:
            imagebutton:
                idle "gui/gallerystuff/locked.jpg"
                xpos 840
                ypos 0
                action NullAction()


    imagebutton xpos 499 ypos 947:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action ShowMenu("gallery7")



screen patreon():
    tag menu

    ## This use statement includes the game_menu screen inside this one. The
    ## vbox child is then included inside the viewport inside the game_menu
    ## screen.
    use game_menu(_("{color=#FF6B2B}Patreon{/color}"), scroll="viewport"):

        style_prefix "about"

        vbox:

            label "[config.name!t]"
            text _(" ")
            text _("Patreon helps me produce more content, and it shows me there is demand for more from this game. I would love to make these games for as long as I can, but that can only happen if I'm able to make a living.")
            text _(" ")
            text _("If at any point in time you enjoy this game, please consider supporting me so I can continue to offer these games for free to everyone.")
            text _(" ")
            text _("Pledging to me grants you access to special stuff like Alpha and Beta builds before the next version officially launches, Patron Only polls, sneak peeks at future content, custom art just for you, and even a whole event written and directed by you!")
            text _(" ")
            text _("{color=#FF6B2B}Patreon: {a=https://www.patreon.com/Runey}Here{/a}{/color}")


screen about():

    tag menu

    ## This use statement includes the game_menu screen inside this one. The
    ## vbox child is then included inside the viewport inside the game_menu
    ## screen.
    use game_menu(_("Info"), scroll="viewport"):

        style_prefix "info"

        vbox:

            label "[config.name!t]"
            text _("Version [config.version!t]\n")
            #text _(" ")
            text _("Made by Runey")
            text _("--------------------")
            text _(" ")
            text _("If you bought this you wasted money. This game will always be free but donations are appreciated!")
            text _(" ")
            text _("The only official download links will be on my Patreon and Discord. Downloading this anywhere else may be risky.")
            text _(" ")
            text _("Need help? Want some advice? Find a bug? Hop in the Discord!")
            text _(" ")
            text _("Discord: {a=https://www.discord.gg/7tSHZNp}Here{/a} or at Patreon.com/Runey")
            text _(" ")
            text _("--------------------")
            text _(" ")
            text _("Patch Notes:")
            text _("    v0.7")
            text _("        You can now ask Lin, Kali, Ashley and Maria to hang out in the hot springs from the lobby")
            text _("        Added the Sanctuary")
            text _("        Added 49 total scenes")
            text _(" ")
            text _("        Lin:")
            text _("            1 Story Event (2 hidden scenes)")
            text _("            Added the footjob stat")
            text _("            Added the footjob trait")
            text _("            Remade Lin's first sleeping event")
            text _("            Added 4 pinup options")
            text _("            Remade Lin's virginity event")
            text _(" ")
            text _("        Kali:")
            text _("            2 Story Events (3 scenes)")
            text _("            You can now visit Kali at work")
            text _(" ")
            text _("        Ashley:")
            text _("            2 Story Events")
            text _("            1 Kate Event")
            text _("            3 new Kate riddles")
            text _(" ")
            text _("        Maria:")
            text _("            2 Story Events")
            text _("            Added 4 Pinup options")
            text _("            Added 1 vaginal sex outfit")
            text _("            Maria will now hang out in her casual wear on the weekends")
            text _("            Remade Maria's room in better quality")
            text _(" ")
            text _("        Android:")
            text _("            2 Story Events")
            text _("            Added 1 vaginal sex outfit")
            text _("            Remade Android's intro event")
            text _(" ")
            text _("        Felicity & Emma:")
            text _("            2 Story Events")
            text _("            Added 2 new outfits for Felicity's vaginal sex animation")
            text _(" ")
            text _("        Autumn:")
            text _("            2 Story Events")
            text _("            You can now visit Autumn at the cafe")
            text _("        The Sanctuary:")
            text _("            Added 2 repeatable blowjobs to Nia")
            text _("            Added repeatable blowjob to Sylvia")
            text _("            Added repeatable sex with Ann")
            text _("            Added the happiness system to the Elves")
            text _("            Added the ability to restrict and allow recreational access to the Elves")
            text _("            Added 3 Story Events to Nia")
            text _("            Added 1 Story Event to Sylvia")
            text _("            Added 1 Story Event to Ann")
            text _(" ")
            text _("        The bugs have returned in force. They have evolved. I am currently writing up an attack plan.")
            text _("        And if all else fails, I'm taking them down with me.")
            text _(" ")
            text _("    v0.7.1")
            text _("        Added new ice cream")
            text _("        Bug Fixes / Polishes")
            text _(" ")
            text _("--------------------")
            text _(" ")
            text _("Harem Hotel Logo: {a=https://spookitty.net/}Here{/a}")
            text _("Main Menu music: {a=https://goo.gl/9AGRKd}Here{/a}")
            text _("BGM 'Easy Lemon': {a=https://incompetech.com/music/royalty-free/music.html}Here{/a}")
            text _("Bar Music: {a=http://freemusicarchive.org/genre/Lounge/}Here{/a}")
            text _(" ")
            text _("Legal:")
            text _("Harem Hotel is the intellectual property of Runey (https://www.patreon.com/Runey).")
            text _("If you wish to get into contact, please message Runey on Discord or Patreon.")
            text _(" ")
            text _("(a) Permission is granted for this material to be shared for non-commercial purposes provided that this statement appears in the reproduced materials.")
            text _("(b) You may NOT sell these files or modify these files to sell, either grouped together or separately. Harem Hotel has been made free for all to enjoy.")
            text _("(c) You may NOT remove or alter the credit of the creator as it is shown here and in the game's files.")
            text _("(d) You may redistribute these files (Harem Hotel) as Harem Hotel for free on your website, or where ever you'd like. But please give credit to the developer (Runey).")
            text _("(e) You may modify these files to your liking to create mods or overhauls so long as the original game and it's developer (Runey) are recognized either in the credits, or is blatantly obvious.")
            text _(" ")
            text _("Models made in Honey Select by Illusion")
            text _(" ")
            ## gui.about is usually set in options.rpy.
            if gui.about:
                text "[gui.about!t]\n"

            text _("Made with {a=https://www.renpy.org/}Ren'Py{/a} [renpy.version_only].\n\n[renpy.license!t]")


## This is redefined in options.rpy to add text to the about screen.
define gui.about = ""


style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size



## Load and Save screens #######################################################
##
## These screens are responsible for letting the player save the game and load
## it again. Since they share nearly everything in common, both are implemented
## in terms of a third screen, file_slots.
##
## https://www.renpy.org/doc/html/screen_special.html#save https://
## www.renpy.org/doc/html/screen_special.html#load



screen sylspaa():
    imagemap:
        idle "sylsitspa1.png"
        hover "sylsitspa2.png"
        hotspot(917, 360, 1114, 638):
            action Jump ("sylspatalk")
screen niaspaa():
    imagemap:
        idle "niasitspa1.png"
        hover "niasitspa2.png"
        hotspot(724, 521, 1090, 847):
            action Jump ("niaspatalk")
screen annspaa():
    imagebutton pos (597, 446) auto "annsitspa_%s.png" action Jump("annspatalk")





screen floor1test():

    if lin_friendship != 11:
        imagebutton pos (51, 243) auto "floor1door1_%s.png" action Jump("lobby2")
    else:
        imagebutton pos (51, 243) auto "floor1door1g_%s.png" action Jump("lobby2")

    imagebutton pos (681, 243) auto "floor1door2_%s.png" action Jump("lobby2")






screen elvesann():

    if hasann and not annisatspa:
        imagebutton pos (560, 179) auto "elfann_%s.png" action Jump("talkann")

    imagebutton pos (0, 8) auto "anndoor_%s.png" action Jump("elftown")





screen elves():

    imagebutton pos (1224, 74) auto "elfdoor_%s.png" action Jump("elfbed")

    if hassylvia and not sylisatspa:
        imagebutton pos (274, 407) auto "elvesylvia_%s.png" action Jump("talksylvia")
    if hasnia and not niaisatspa:
            if niapoint == 0:
                imagebutton pos (871, 236) auto "elvesnia_%s.png" action Jump("talknia")
            if niapoint == 1 and time_of_day !=3:
                imagebutton pos (858, 243) auto "elvesniap2_%s.png" action Jump("talknia")
            if niapoint == 2:
                imagebutton pos (855, 245) auto "elvesniap3_%s.png" action Jump("talknia")


screen barb():
    if mooncat == True:
        imagemap:
            idle "barmooncat.webp"
            hover "barmooncath.webp"
            #hotspot (795, 362, 961, 823):
            hotspot (841, 373, 128, 427):
                action Jump("barmooncat")
    if mooncat == False:
        imagemap:
            idle "barmoon.webp"
            hover "barmoonh.webp"
            #hotspot (795, 362, 961, 823):
            hotspot (841, 373, 128, 427):
                action Jump("barmoon")


    if marbar1 == 3 and time_of_day == 3 and (day%7) !=6 and (day%7) != 0:
        imagemap:
            idle "barmart.webp"
            hover "barmarth.webp"
            #hotspot (509, 315, 644, 542):
            hotspot (509, 315, 128, 427):
                action Jump("barmart")
    else:
        imagemap:
            idle "barbart.webp"
            hover "barbarth.webp"
            #hotspot (509, 315, 644, 542):
            hotspot (509, 315, 128, 427):
                action Jump("barbart")

    if (day%7) == 6:
        imagemap:
            idle "sarah.webp"
            hover "sarahh.webp"
            #hotspot (509, 315, 644, 542):
            hotspot (359, 352, 288, 559):
                action Jump("barsarah")




screen patreon1():
    frame:
        xalign 0.5 ypos 500
        vbox:
            textbutton _("Visit Website"):
                action OpenURL("https://www.patreon.com/Runey")



screen phoneash():
    add "phoneash.png" xalign 0.5 yalign 0.9

screen backe():
    imagebutton xalign 0.02 ypos 975:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action Jump("elftown")

screen back():
    imagebutton xalign 0.02 ypos 975:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action Jump("prelobby")

screen back0():
    imagebutton xalign 0.02 ypos 975:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action Jump("barprelobby")

screen jumpbar():
    imagebutton xalign 0.98 ypos 975:
        idle "gui/btn_bar.png"
        hover "gui/btn_bar_over.png"
        action Jump("prebar")

screen fasttravel():
    imagebutton xalign 0.98 ypos 960:
        idle "gui/btn_up.png"
        hover "gui/btn_up_high.png"
        action Show("fast_travel")
screen fast_travel:
    fixed:
         text "Fast travel to.." xalign 0.5 yalign 0.3
         textbutton "Floor 1" xalign 0.25 yalign 0.5 action Jump("lobby")
         textbutton "Floor 2" xalign 0.50 yalign 0.5 action Jump("floor2")
         textbutton "Back" xalign 0.75 yalign 0.5 action Hide("fast_travel")

screen back2():
    imagebutton xalign 0.02 ypos 975:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action Jump("prefloor1")


screen back3():
    imagebutton xalign 0.02 ypos 975:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action Jump("prefloor2")

screen back4():
    imagebutton xalign 0.02 ypos 975:
        idle "gui/btn_back.png"
        hover "gui/btn_back_over.png"
        action Jump("preutility")


screen kitchen():
    frame:
        xalign 0.02 ypos 950
        vbox:
            #text _("Back")
            textbutton _("Kitchen"):
                action Jump("kitchen")

screen yourroom():
    frame:
        xalign 0.02 ypos 800
        vbox:
            #text _("Back")
            textbutton _("Your Room"):
                action Jump("yourroom")





screen spring():
    frame:
        xalign 0.5 ypos 750
        vbox:
            #text _("Back")
            textbutton _("Spring"):
                action Jump("spring")

screen springash():
    frame:
        xalign 0.5 ypos 750
        vbox:
            #text _("Back")
            textbutton _("Spring"):
                action Jump("springash")

screen daynumber():
    vbox:
        xalign 0.5 ypos 395

        text "{font=dayfont2.ttf}{size=+175}{color=#FFFFFF}Day [day]{/color}{/size}{/font}" at truecenter




screen springkali():
    frame:
        xalign 0.5 ypos 700
        vbox:
            #text _("Back")
            textbutton _("Spring"):
                action Jump("springkali")

#screen stats():
#    frame:
#        xalign 0.98 ypos 975
#        vbox:
#            textbutton _("Stats"):
#                action [Show ("statpage"), Show("statshide"), Hide("frontdoor"),Hide("advance_time"), Hide("stats")]

screen stats():
    zorder 101
    imagebutton xalign 0.70185 ypos 0:
        idle "gui/btn_info.png"
        hover "gui/btn_info_over.png"
#        action [Show ("statpage"), Show("statshide"), Hide("frontdoor"),Hide("advance_time"), Hide("stats")]
        action [Show ("statpage"), Show("statshide")]

screen statshide():
    frame:
        xalign 0.5 ypos 745
        vbox:
            textbutton _("Hide"):
                if inbar == True:
                    action [Hide("statpage"), Hide ("botstats"), Hide ("marstats"), Hide("linstats"), Hide("ashstats"), Hide("kalistats"), Hide("statshide"), Show("stats")]
                elif time_of_day <=4 and inbar == False:
                    action [Hide("statpage"), Hide ("botstats"), Hide ("marstats"), Hide("linstats"), Hide("ashstats"), Hide("kalistats"), Hide("statshide"), Show("advance_time"), Show("stats")]
                else:
                    action [Hide("statpage"), Hide ("botstats"), Hide ("marstats"), Hide("linstats"), Hide("ashstats"), Hide("kalistats"), Hide("statshide"), Show("stats")]


screen statpage():
    modal True
    frame:
        padding (80, 40)
        align (0.5, 0.5)
        vbox:
            hbox at truecenter:
                spacing 20
                vbox:
                    spacing 6
                    textbutton "Lin" action ui.callsinnewcontext ("call_linstat") align (0.5, 0.5)
                    textbutton "Kali" action ui.callsinnewcontext ("call_kalistat") align (0.5, 0.5)
                    if ash_friendship < 1:
                        textbutton "???" align (0.5, 0.5)
                    else:
                        textbutton "Ashley" action ui.callsinnewcontext ("call_ashstat") align (0.5, 0.5)
                    if mariaintro == False:
                        textbutton "???" align (0.5, 0.5)
                    else:
                        textbutton "Maria" action ui.callsinnewcontext ("call_marstat") align (0.5, 0.5)
                vbox:
                    spacing 6
                    if bot_friendship < 1:
                        textbutton "???" align (0.5, 0.5)
                    else:
                        textbutton "[botname]" action ui.callsinnewcontext ("call_botstat") align (0.5, 0.5)
                    if twin_friendship < 1:
                        textbutton "???" align (0.5, 0.5)
                    else:
                        textbutton "Felicity" action ui.callsinnewcontext ("call_felstat") align (0.5, 0.5)
                    if twin_friendship < 1:
                        textbutton "???" align (0.5, 0.5)
                    else:
                        textbutton "Emma" action ui.callsinnewcontext ("call_emstat") align (0.5, 0.5)
                    if aut_friendship < 1:
                        textbutton "???" align (0.5, 0.5)
                    else:
                        textbutton "Autumn" action ui.callsinnewcontext ("call_autstat") align (0.5, 0.5)
            hbox at truecenter:
                vbox:
                    spacing -30
                    text "" align (0.5, 0.5)
                    textbutton "Side Character Info" action ui.callsinnewcontext ("call_sidestat") align (0.5, 0.5)
            if vcode:
                hbox at truecenter:
                    vbox:
                        spacing -40
                        text "" align (0.5, 0.5)
                        textbutton "Violet (unofficial)" action ui.callsinnewcontext ("call_viostat") align (0.5, 0.5)
#
# if renpy.variant("pc"):
#     screen statpage():
#         modal True
#         frame:
#             xmaximum 500
#             ymaximum 225
#             xalign 0.5
#             yalign 0.5
#             vbox:
#                 xalign 0.135
#                 yalign -0.149
#                 text _("                                       ")
#                 textbutton("Lin") at truecenter:
#                     action ui.callsinnewcontext ("call_linstat")
#             vbox:
#                 xalign 0.35
#                 yalign 0.4
#                 textbutton("Kali") at truecenter:
#                     action ui.callsinnewcontext ("call_kalistat")
#             vbox:
#                 xalign 0.35
#                 yalign 0.65
#                 if ash_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Ashley") at truecenter:
#                         action ui.callsinnewcontext ("call_ashstat")
#             vbox:
#                 xalign 0.35
#                 yalign 0.9
#                 if mar_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Maria") at truecenter:
#                         action ui.callsinnewcontext ("call_marstat")
#             vbox:
#                 xalign 0.65
#                 yalign 0.12
#                 if bot_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("[botname]") at truecenter:
#                         action ui.callsinnewcontext ("call_botstat")
#             vbox:
#                 xalign 0.65
#                 yalign 0.4
#                 if twin_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Felicity") at truecenter:
#                         action ui.callsinnewcontext ("call_felstat")
#             vbox:
#                 xalign 0.65
#                 yalign 0.65
#                 if twin_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Emma") at truecenter:
#                         action ui.callsinnewcontext ("call_emstat")
#             vbox:
#                 xalign 0.65
#                 yalign 0.9
#                 if aut_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Autumn") at truecenter:
#                         action ui.callsinnewcontext ("call_autstat")
#             vbox:
#                 xalign 1.4
#                 yalign 0.136
#                 if vcode == True:
#                     textbutton("Violet") at truecenter:
#                         action ui.callsinnewcontext ("call_viostat")
#                 text _("                                       ")
#
# else:
#     #Android v
#     screen statpage():
#         modal True
#         frame:
#             xmaximum 500
#             ymaximum 300
#             xalign 0.5
#             yalign 0.5
#
#             vbox:
#                 xalign 0.26
#                 yalign 0.2
#                 textbutton("Lin") at truecenter:
#                     action ui.callsinnewcontext ("call_linstat")
#
#             vbox:
#                 xalign 0.255
#                 yalign 0.42
#                 textbutton("Kali") at truecenter:
#                     action ui.callsinnewcontext ("call_kalistat")
#             vbox:
#                 xalign 0.23
#                 yalign 0.64
#                 if ash_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Ashley") at truecenter:
#                         action ui.callsinnewcontext ("call_ashstat")
#             vbox:
#                 xalign 0.24
#                 yalign 0.86
#                 if mar_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Maria") at truecenter:
#                         action ui.callsinnewcontext ("call_marstat")
#             vbox:
#                 xalign 0.74
#                 yalign 0.2
#                 if bot_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("[botname]") at truecenter:
#                         action ui.callsinnewcontext ("call_botstat")
#             vbox:
#                 xalign 0.77
#                 yalign 0.42
#                 if twin_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Felicity") at truecenter:
#                         action ui.callsinnewcontext ("call_felstat")
#             vbox:
#                 xalign 0.76
#                 yalign 0.64
#                 if twin_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Emma") at truecenter:
#                         action ui.callsinnewcontext ("call_emstat")
#             vbox:
#                 xalign 0.78
#                 yalign 0.86
#                 if aut_friendship < 1:
#                     textbutton("???") at truecenter
#                 else:
#                     textbutton("Autumn") at truecenter:
#                         action ui.callsinnewcontext ("call_autstat")
#             vbox:
#                 xalign 0.5
#                 yalign 5
#                 if vcode == True:
#                     textbutton("Violet") at truecenter:
#                         action ui.callsinnewcontext ("call_viostat")
#                 text _("                                       ")




screen autumnstat():
    add "autstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[aut_friendship]{/size}"


    vbox:
        xpos 50 ypos 525
        if aut_aff < 4: # 0 - 3
            text "{size=+10}Afecto:{/size} {size=+10}[aut_aff] | Extraño{/size}"
        if aut_aff > 3 and aut_aff < 7: #4 - 6
            text "{size=+10}Afecto:{/size} {size=+10}[aut_aff] | Conocidos{/size}"
        if aut_aff >6 and aut_aff < 10: # 7 - 9
            text "{size=+10}Afecto:{/size} {size=+10}[aut_aff] | Amigos{/size}"
        if aut_aff > 9 and aut_aff < 13: #10 - 12
            text "{size=+10}Afecto:{/size} {size=+10}[aut_aff] | Amigos cercanos{/size}"
        if aut_aff > 12: #13
            text "{size=+10}Afecto:{/size} {size=+10}[aut_aff] | Amantes{/size}"


#    vbox:
#        xpos 50 ypos 570
#        if aut_slut < 4: # 0 - 3
#            text "{size=+10}Puta:{/size} {size=+10}[aut_slut] | Pure{/size}"
#        if aut_slut > 3 and aut_slut < 7: #4 - 6
#            text "{size=+10}Puta:{/size} {size=+10}[aut_slut] | Tainted{/size}"
#        if aut_slut >6 and aut_slut < 10: # 7 - 9
#            text "{size=+10}Puta:{/size} {size=+10}[aut_slut] | Corrupted{/size}"
#        if aut_slut > 9 and aut_slut < 13: #10 - 12
#            text "{size=+10}Puta:{/size} {size=+10}[aut_slut] | Slutty{/size}"
#        if aut_slut > 12: #13
#            text "{size=+10}Nivel de puta{/size} {size=+10}[aut_slut] | Whore{/size}"

#    vbox:
#        xpos 50 ypos 615
#        if aut_ex < 4: # 0 - 3
#            text "{size=+10}Exhibitionism:{/size} {size=+10}[aut_ex] | Indiferente{/size}"
#        if aut_ex > 3 and aut_ex < 7: #4 - 6
#            text "{size=+10}Exhibitionism:{/size} {size=+10}[aut_ex] | Questionable{/size}"
#        if aut_ex >6 and aut_ex < 10: # 7 - 9
#            text "{size=+10}Exhibitionism:{/size} {size=+10}[aut_ex] | Nerviosa{/size}"
#        if aut_ex > 9 and aut_ex < 13: #10 - 12
#            text "{size=+10}Exhibitionism:{/size} {size=+10}[aut_ex] | Atrevida{/size}"
#        if aut_ex > 12: #13
#            text "{size=+10}Exhibitionism:{/size} {size=+10}[aut_ex] | Exhibicionista{/size}"


    frame:
        style_prefix "stats"


        vbox:
            xalign 0.5
            ypos 360
            if aut_aff < 10:
                text ("{color=#474747}Enamorada{/color}")
            if aut_aff > 9:
                text ("{color=#FFFFFF}Enamorada{/color}")

        #vbox:
        #    xalign 0.5
        #    yalign 0.35
        #    if fel_aff < 10:
        #        text ("{color=#474747}In Love{/color}")
        #    if fel_aff > 9:
        #        text ("{color=#FFFFFF}In Love{/color}")




screen ashleystat():
    add "ashstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[ash_friendship]{/size}"


    vbox:
        if ash_aff < 4: # 0 - 3
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[ash_aff] | Extraño{/size}"
        if ash_aff > 3 and ash_aff < 7: #4 - 6
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[ash_aff] | Conocidos{/size}"
        if ash_aff >6 and ash_aff < 10: # 7 - 9
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[ash_aff] | Amigos{/size}"
        if ash_aff > 9 and ash_aff < 13: #10 - 12
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[ash_aff] | Amigos cercanos{/size}"
        if ash_aff > 12: #13
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[ash_aff] | Amantes{/size}"


    vbox:
        if ash_slut < 4: # 0 - 3
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[ash_slut] | Pura{/size}"
        if ash_slut > 3 and ash_slut < 7: #4 - 6
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[ash_slut] | Tainted{/size}"
        if ash_slut >6 and ash_slut < 10: # 7 - 9
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[ash_slut] | Corrupted{/size}"
        if ash_slut > 9 and ash_slut < 13: #10 - 12
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[ash_slut] | Putita{/size}"
        if ash_slut > 12: #13
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[ash_slut] | Puta{/size}"
    vbox:
        if ash_ex < 4: # 0 - 3
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[ash_ex] | Indiferente{/size}"
        if ash_ex > 3 and ash_ex < 7: #4 - 6
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[ash_ex] | Questionable{/size}"
        if ash_ex >6 and ash_ex < 10: # 7 - 9
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[ash_ex] | Nerviosa{/size}"
        if ash_ex > 9 and ash_ex < 13: #10 - 12
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[ash_ex] | Atrevida{/size}"
        if ash_ex > 12: #13
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[ash_ex] | Exhibicionista{/size}"

    vbox:
        if ash_sub < 4: # 0 - 3
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[ash_sub] | Pasiva{/size}"
        if ash_sub > 3 and ash_sub < 7: #4 - 6
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[ash_sub] | Flexible{/size}"
        if ash_sub >6 and ash_sub < 10: # 7 - 9
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[ash_sub] | Servicial{/size}"
        if ash_sub > 9 and ash_sub < 13: #10 - 12
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[ash_sub] | Dutiful{/size}"
        if ash_sub > 12: #13
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[ash_sub] | Obedient{/size}"


    vbox:
        if ash_blowjobs < 4: # 0 - 3
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[ash_blowjobs] | Inexperta{/size}"
        if ash_blowjobs > 3 and ash_blowjobs < 7: # 4 - 6
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[ash_blowjobs] | experimentada{/size}"
        if ash_blowjobs > 6 and ash_blowjobs < 10: # 7 - 9
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[ash_blowjobs] | Hábil{/size}"
        if ash_blowjobs > 9 and ash_blowjobs < 13: # 10 - 12
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[ash_blowjobs] | Expert{/size}"
        if ash_blowjobs > 12: # 13
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[ash_blowjobs] | Professional{/size}"

    vbox:
        if ash_thigh < 4: # 0 - 3
            xpos 50 ypos 790
            text "{size=+10}Thighjobs:{/size} {size=+10}[ash_thigh] | Inexperta{/size}"
        if ash_thigh > 3 and ash_thigh < 7: # 4 - 6
            xpos 50 ypos 790
            text "{size=+10}Thighjobs:{/size} {size=+10}[ash_thigh] | experimentada{/size}"
        if ash_thigh > 6 and ash_thigh < 10: # 7 - 9
            xpos 50 ypos 790
            text "{size=+10}Thighjobs:{/size} {size=+10}[ash_thigh] | Hábil{/size}"
        if ash_thigh > 9 and ash_thigh < 13: # 10 - 12
            xpos 50 ypos 790
            text "{size=+10}Thighjobs:{/size} {size=+10}[ash_thigh] | Expert{/size}"
        if ash_thigh > 12: # 13
            xpos 50 ypos 790
            text "{size=+10}Thighjobs:{/size} {size=+10}[ash_thigh] | Professional{/size}"

    vbox:
        if ash_sex < 4: # 0 - 3
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[ash_sex] | Inexperta{/size}"
        if ash_sex > 3 and ash_sex < 7: # 4 - 6
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[ash_sex] | experimentada{/size}"
        if ash_sex > 6 and ash_sex < 10: # 7 - 9
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[ash_sex] | Hábil{/size}"
        if ash_sex > 9 and ash_sex < 13: # 10 - 12
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[ash_sex] | Expert{/size}"
        if ash_sex > 12: # 13
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[ash_sex] | Professional{/size}"

    vbox:
        if ash_anal1 < 4: # 0 - 3
            xpos 50 ypos 925
            text "{size=+10}Anal Sex:{/size} {size=+10}[ash_anal1] | Inexperta{/size}"
        if ash_anal1 > 3 and ash_anal1 < 7: # 4 - 6
            xpos 50 ypos 925
            text "{size=+10}Anal Sex:{/size} {size=+10}[ash_anal1] | experimentada{/size}"
        if ash_anal1 > 6 and ash_anal1 < 10: # 7 - 9
            xpos 50 ypos 925
            text "{size=+10}Anal Sex:{/size} {size=+10}[ash_anal1] | Hábil{/size}"
        if ash_anal1 > 9 and ash_anal1 < 13: # 10 - 12
            xpos 50 ypos 925
            text "{size=+10}Anal Sex:{/size} {size=+10}[ash_anal1] | Expert{/size}"
        if ash_anal1 > 12: # 13
            xpos 50 ypos 925
            text "{size=+10}Anal Sex:{/size} {size=+10}[ash_anal1] | Professional{/size}"

    vbox:
        if ash_footjobs < 4: # 0 - 3
            xpos 50 ypos 745
            text "{size=+10}Footjobs:{/size} {size=+10}[ash_footjobs] | Inexperta{/size}"
        if ash_footjobs > 3 and ash_footjobs < 7: # 4 - 6
            xpos 50 ypos 745
            text "{size=+10}Footjobs:{/size} {size=+10}[ash_footjobs] | experimentada{/size}"
        if ash_footjobs > 6 and ash_footjobs < 10: # 7 - 9
            xpos 50 ypos 745
            text "{size=+10}Footjobs:{/size} {size=+10}[ash_footjobs] | Hábil{/size}"
        if ash_footjobs > 9 and ash_footjobs < 13: # 10 - 12
            xpos 50 ypos 745
            text "{size=+10}Footjobs:{/size} {size=+10}[ash_footjobs] | Expert{/size}"
        if ash_footjobs > 12: # 13
            xpos 50 ypos 745
            text "{size=+10}Footjobs:{/size} {size=+10}[ash_footjobs] | Professional{/size}"



    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if ash_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if ash_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")
        vbox:
            xalign 0.5
            yalign 0.4
            if ash_cum < 10:
                text ("{color=#474747}puta trga leche{/color}")
            if ash_cum > 9:
                text ("{color=#FFFFFF}puta trga leche{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if ash_blowjobs < 10:
                text ("{color=#474747}Professional Cocksucker{/color}")
            if ash_blowjobs > 9:
                text ("{color=#FFFFFF}Professional Cocksucker{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if ash_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if ash_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if ash_anal1 < 10:
                text ("{color=#474747}Buttslut{/color}")
            if ash_anal1 > 9:
                text ("{color=#FFFFFF}Buttslut{/color}")
        vbox:
            xalign 0.5
            yalign 0.6
            if ash_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if ash_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")
        vbox:
            xalign 0.5
            yalign 0.65
            if ash_aff < 15:
                text ("{color=#474747}Enamorada{/color}")
            if ash_aff > 14:
                text ("{color=#FFFFFF}Enamorada{/color}")
        vbox:
            xalign 0.5
            yalign 0.7
            if ash_footjobs < 10:
                text ("{color=#474747}fetiche de pies{/color}")
            if ash_footjobs > 9:
                text ("{color=#FFFFFF}fetiche de pies{/color}")

        vbox:
            xalign 0.5
            yalign 0.75
            if ash_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if ash_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")

        vbox:
            xalign 0.5
            yalign 0.8
            if ash_sub < 10:
                text ("{color=#474747}Submissive{/color}")
            if ash_sub > 9:
                text ("{color=#FFFFFF}Submissive{/color}")


screen kalistat():
    add "kalistats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[kali_friendship]{/size}"


    vbox:
        if kali_aff < 4: # 0 - 3
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[kali_aff] | Extraño{/size}"
        if kali_aff > 3 and kali_aff < 7: #4 - 6
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[kali_aff] | Conocidos{/size}"
        if kali_aff >6 and kali_aff < 10: # 7 - 9
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[kali_aff] | Amigos{/size}"
        if kali_aff > 9 and kali_aff < 13: #10 - 12
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[kali_aff] | Amigos cercanos{/size}"
        if kali_aff > 12: #13
            xpos 50 ypos 525
            text "{size=+10}Afecto:{/size} {size=+10}[kali_aff] | Amantes{/size}"


    vbox:
        if kali_slut < 4: # 0 - 3
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[kali_slut] | Pura{/size}"
        if kali_slut > 3 and kali_slut < 7: #4 - 6
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[kali_slut] | Tainted{/size}"
        if kali_slut >6 and kali_slut < 10: # 7 - 9
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[kali_slut] | Corrupted{/size}"
        if kali_slut > 9 and kali_slut < 13: #10 - 12
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[kali_slut] | Putita{/size}"
        if kali_slut > 12: #13
            xpos 50 ypos 570
            text "{size=+10}Nivel de puta{/size} {size=+10}[kali_slut] | Puta{/size}"
    vbox:
        if kali_ex < 4: # 0 - 3
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[kali_ex] | Indiferente{/size}"
        if kali_ex > 3 and kali_ex < 7: #4 - 6
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[kali_ex] | Questionable{/size}"
        if kali_ex >6 and kali_ex < 10: # 7 - 9
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[kali_ex] | Nerviosa{/size}"
        if kali_ex > 9 and kali_ex < 13: #10 - 12
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[kali_ex] | Atrevida{/size}"
        if kali_ex > 12: #13
            xpos 50 ypos 615
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[kali_ex] | Exhibicionista{/size}"

    vbox:
        if kali_sub < 4: # 0 - 3
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[kali_sub] | Pasiva{/size}"
        if kali_sub > 3 and kali_sub < 7: #4 - 6
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[kali_sub] | Flexible{/size}"
        if kali_sub >6 and kali_sub < 10: # 7 - 9
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[kali_sub] | Servicial{/size}"
        if kali_sub > 9 and kali_sub < 13: #10 - 12
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[kali_sub] | Dutiful{/size}"
        if kali_sub > 12: #13
            xpos 50 ypos 660
            text "{size=+10}Submission:{/size} {size=+10}[kali_sub] | Obedient{/size}"


    vbox:
        if kali_blowjobs < 4: # 0 - 3
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[kali_blowjobs] | Inexperta{/size}"
        if kali_blowjobs > 3 and kali_blowjobs < 7: # 4 - 6
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[kali_blowjobs] | experimentada{/size}"
        if kali_blowjobs > 6 and kali_blowjobs < 10: # 7 - 9
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[kali_blowjobs] | Hábil{/size}"
        if kali_blowjobs > 9 and kali_blowjobs < 13: # 10 - 12
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[kali_blowjobs] | Expert{/size}"
        if kali_blowjobs > 12: # 13
            xpos 50 ypos 835
            text "{size=+10}Mamadas:{/size} {size=+10}[kali_blowjobs] | Professional{/size}"

    vbox:
        if kali_thigh < 4: # 0 - 3
            xpos 50 ypos 745
            text "{size=+10}Thighjobs:{/size} {size=+10}[kali_thigh] | Inexperta{/size}"
        if kali_thigh > 3 and kali_thigh < 7: # 4 - 6
            xpos 50 ypos 745
            text "{size=+10}Thighjobs:{/size} {size=+10}[kali_thigh] | experimentada{/size}"
        if kali_thigh > 6 and kali_thigh < 10: # 7 - 9
            xpos 50 ypos 745
            text "{size=+10}Thighjobs:{/size} {size=+10}[kali_thigh] | Hábil{/size}"
        if kali_thigh > 9 and kali_thigh < 13: # 10 - 12
            xpos 50 ypos 745
            text "{size=+10}Thighjobs:{/size} {size=+10}[kali_thigh] | Expert{/size}"
        if kali_thigh > 12: # 13
            xpos 50 ypos 745
            text "{size=+10}Thighjobs:{/size} {size=+10}[kali_thigh] | Professional{/size}"

    vbox:
        if kali_boobjobs < 4: # 0 - 3
            xpos 50 ypos 790
            text "{size=+10}Boobjobs:{/size} {size=+10}[kali_boobjobs] | Inexperta{/size}"
        if kali_boobjobs > 3 and kali_boobjobs < 7: # 4 - 6
            xpos 50 ypos 790
            text "{size=+10}Boobjobs:{/size} {size=+10}[kali_boobjobs] | experimentada{/size}"
        if kali_boobjobs > 6 and kali_boobjobs < 10: # 7 - 9
            xpos 50 ypos 790
            text "{size=+10}Boobjobs:{/size} {size=+10}[kali_boobjobs] | Hábil{/size}"
        if kali_boobjobs > 9 and kali_boobjobs < 13: # 10 - 12
            xpos 50 ypos 790
            text "{size=+10}Boobjobs:{/size} {size=+10}[kali_boobjobs] | Expert{/size}"
        if kali_boobjobs > 12: # 13
            xpos 50 ypos 790
            text "{size=+10}Boobjobs:{/size} {size=+10}[kali_boobjobs] | Professional{/size}"

    vbox:
        if kali_sex < 4: # 0 - 3
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[kali_sex] | Inexperta{/size}"
        if kali_sex > 3 and kali_sex < 7: # 4 - 6
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[kali_sex] | experimentada{/size}"
        if kali_sex > 6 and kali_sex < 10: # 7 - 9
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[kali_sex] | Hábil{/size}"
        if kali_sex > 9 and kali_sex < 13: # 10 - 12
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[kali_sex] | Expert{/size}"
        if kali_sex > 12: # 13
            xpos 50 ypos 880
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[kali_sex] | Professional{/size}"

    vbox:
        if kali_anal < 4: # 0 - 3
            xpos 50 ypos 925
            text "{size=+15}Anal Sex:{/size} {size=+10}[kali_anal] | Inexperta{/size}"
        if kali_anal > 3 and kali_anal < 7: # 4 - 6
            xpos 50 ypos 925
            text "{size=+15}Anal Sex:{/size} {size=+10}[kali_anal] | experimentada{/size}"
        if kali_anal > 6 and kali_anal < 10: # 7 - 9
            xpos 50 ypos 925
            text "{size=+15}Anal Sex:{/size} {size=+10}[kali_anal] | Hábil{/size}"
        if kali_anal > 9 and kali_anal < 13: # 10 - 12
            xpos 50 ypos 925
            text "{size=+15}Anal Sex:{/size} {size=+10}[kali_anal] | Expert{/size}"
        if kali_anal > 12: # 13
            xpos 50 ypos 925
            text "{size=+15}Anal Sex:{/size} {size=+10}[kali_anal] | Professional{/size}"


    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if kali_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if kali_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")
        vbox:
            xalign 0.5
            yalign 0.4
            if kali_cum < 10:
                text ("{color=#474747}PUTA TRAGA LECHE{/color}")
            if kali_cum > 9:
                text ("{color=#FFFFFF}PUTA TRAGA LECHE{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if kali_blowjobs < 10:
                text ("{color=#474747}Chupavergas profesional{/color}")
            if kali_blowjobs > 9:
                text ("{color=#FFFFFF}Chupavergas profesional{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if kali_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if kali_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if kali_boobjobs < 10:
                text ("{color=#474747}Paizuri Star{/color}")
            if kali_boobjobs > 9:
                text ("{color=#FFFFFF}Paizuri Star{/color}")
        vbox:
            xalign 0.5
            yalign 0.6
            if kali_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if kali_slut > 9:
                text ("{color=#FFFFFF}Mega puta{/color}")
        vbox:
            xalign 0.5
            yalign 0.65
            if kali_aff < 15:
                text ("{color=#474747}Enamorada{/color}")
            if kali_aff > 14:
                text ("{color=#FFFFFF}Enamorada{/color}")

        vbox:
            xalign 0.5
            yalign 0.7
            if kali_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if kali_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")

        vbox:
            xalign 0.5
            yalign 0.75
            if kali_sub < 10:
                text ("{color=#474747}Submissive{/color}")
            if kali_sub > 9:
                text ("{color=#FFFFFF}Submissive{/color}")

        vbox:
            xalign 0.5
            yalign 0.8
            if kali_anal < 10:
                text ("{color=#474747}Buttslut{/color}")
            if kali_anal > 9:
                text ("{color=#FFFFFF}Buttslut{/color}")


screen marstat():
    add "marstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[mar_friendship]{/size}"


    vbox:
        xpos 50 ypos 525
        if mar_aff < 4: # 0 - 3
            text "{size=+10}Afecto:{/size} {size=+10}[mar_aff] | Extraño{/size}"
        if mar_aff > 3 and mar_aff < 7: #4 - 6
            text "{size=+10}Afecto:{/size} {size=+10}[mar_aff] | Conocidos{/size}"
        if mar_aff >6 and mar_aff < 10: # 7 - 9
            text "{size=+10}Afecto:{/size} {size=+10}[mar_aff] | Amigos{/size}"
        if mar_aff > 9 and mar_aff < 13: #10 - 12
            text "{size=+10}Afecto:{/size} {size=+10}[mar_aff] | Amigos cercanos{/size}"
        if mar_aff > 12: #13
            text "{size=+10}Afecto:{/size} {size=+10}[mar_aff] | Amantes{/size}"


    vbox:
        xpos 50 ypos 570
        if mar_slut < 4: # 0 - 3
            text "{size=+10}Nivel de puta{/size} {size=+10}[mar_slut] | Pura{/size}"
        if mar_slut > 3 and mar_slut < 7: #4 - 6
            text "{size=+10}Nivel de puta{/size} {size=+10}[mar_slut] | Tainted{/size}"
        if mar_slut >6 and mar_slut < 10: # 7 - 9
            text "{size=+10}Nivel de puta{/size} {size=+10}[mar_slut] | Corrupted{/size}"
        if mar_slut > 9 and mar_slut < 13: #10 - 12
            text "{size=+10}Nivel de puta{/size} {size=+10}[mar_slut] | Putita{/size}"
        if mar_slut > 12: #13
            text "{size=+10}Nivel de puta{/size} {size=+10}[mar_slut] | Puta{/size}"

    vbox:
        xpos 50 ypos 615
        if mar_ex < 4: # 0 - 3
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[mar_ex] | Indiferente{/size}"
        if mar_ex > 3 and mar_ex < 7: #4 - 6
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[mar_ex] | Questionable{/size}"
        if mar_ex >6 and mar_ex < 10: # 7 - 9
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[mar_ex] | Nerviosa{/size}"
        if mar_ex > 9 and mar_ex < 13: #10 - 12
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[mar_ex] | Atrevida{/size}"
        if mar_ex > 12: #13
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[mar_ex] | Exhibicionista{/size}"

    vbox:
        xpos 50 ypos 660
        if mar_sub < 4: # 0 - 3
            text "{size=+10}Submission:{/size} {size=+10}[mar_sub] | Pasiva{/size}"
        if mar_sub > 3 and mar_sub < 7: #4 - 6
            text "{size=+10}Submission:{/size} {size=+10}[mar_sub] | Flexible{/size}"
        if mar_sub >6 and mar_sub < 10: # 7 - 9
            text "{size=+10}Submission:{/size} {size=+10}[mar_sub] | Servicial{/size}"
        if mar_sub > 9 and mar_sub < 13: #10 - 12
            text "{size=+10}Submission:{/size} {size=+10}[mar_sub] | Dutiful{/size}"
        if mar_sub > 12: #13
            text "{size=+10}Submission:{/size} {size=+10}[mar_sub] | Obedient{/size}"


    vbox:
        xpos 50 ypos 745
        if mar_hj < 4: # 0 - 3
            text "{size=+10}Handjobs:{/size} {size=+10}[mar_hj] | Inexperta{/size}"
        if mar_hj > 3 and mar_hj < 7: # 4 - 6
            text "{size=+10}Handjobs:{/size} {size=+10}[mar_hj] | experimentada{/size}"
        if mar_hj > 6 and mar_hj < 10: # 7 - 9
            text "{size=+10}Handjobs:{/size} {size=+10}[mar_hj] | Hábil{/size}"
        if mar_hj > 9 and mar_hj < 13: # 10 - 12
            text "{size=+10}Handjobs:{/size} {size=+10}[mar_hj] | Expert{/size}"
        if mar_hj > 12: # 13
            text "{size=+10}Handjobs:{/size} {size=+10}[mar_hj] | Professional{/size}"

    vbox:
        xpos 50 ypos 790
        if mar_blowjobs < 4: # 0 - 3
            text "{size=+10}Mamadas:{/size} {size=+10}[mar_blowjobs] | Inexperta{/size}"
        if mar_blowjobs > 3 and mar_blowjobs < 7: # 4 - 6
            text "{size=+10}Mamadas:{/size} {size=+10}[mar_blowjobs] | experimentada{/size}"
        if mar_blowjobs > 6 and mar_blowjobs < 10: # 7 - 9
            text "{size=+10}Mamadas:{/size} {size=+10}[mar_blowjobs] | Hábil{/size}"
        if mar_blowjobs > 9 and mar_blowjobs < 13: # 10 - 12
            text "{size=+10}Mamadas:{/size} {size=+10}[mar_blowjobs] | Expert{/size}"
        if mar_blowjobs > 12: # 13
            text "{size=+10}Mamadas:{/size} {size=+10}[mar_blowjobs] | Professional{/size}"

    vbox:
        xpos 50 ypos 835
        if mar_cun < 4: # 0 - 3
            text "{size=+10}Cunnilingus:{/size} {size=+10}[mar_cun] | Inexperta{/size}"
        if mar_cun > 3 and mar_cun < 7: # 4 - 6
            text "{size=+10}Cunnilingus:{/size} {size=+10}[mar_cun] | experimentada{/size}"
        if mar_cun > 6 and mar_cun < 10: # 7 - 9
            text "{size=+10}Cunnilingus:{/size} {size=+10}[mar_cun] | Hábil{/size}"
        if mar_cun > 9 and mar_cun < 13: # 10 - 12
            text "{size=+10}Cunnilingus:{/size} {size=+10}[mar_cun] | Expert{/size}"
        if mar_cun > 12: # 13
            text "{size=+10}Cunnilingus:{/size} {size=+10}[mar_cun] | Professional{/size}"


    vbox:
        xpos 50 ypos 880
        if mar_sex < 4: # 0 - 3
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[mar_sex] | Inexperta{/size}"
        if mar_sex > 3 and mar_sex < 7: # 4 - 6
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[mar_sex] | experimentada{/size}"
        if mar_sex > 6 and mar_sex < 10: # 7 - 9
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[mar_sex] | Hábil{/size}"
        if mar_sex > 9 and mar_sex < 13: # 10 - 12
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[mar_sex] | Expert{/size}"
        if mar_sex > 12: # 13
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[mar_sex] | Professional{/size}"

    vbox:
        xpos 50 ypos 925
        if mar_anal < 4: # 0 - 3
            text "{size=+10}Anal Sex:{/size} {size=+10}[mar_anal] | Inexperta{/size}"
        if mar_anal > 3 and mar_anal < 7: # 4 - 6
            text "{size=+10}Anal Sex:{/size} {size=+10}[mar_anal] | experimentada{/size}"
        if mar_anal > 6 and mar_anal < 10: # 7 - 9
            text "{size=+10}Anal Sex:{/size} {size=+10}[mar_anal] | Hábil{/size}"
        if mar_anal > 9 and mar_anal < 13: # 10 - 12
            text "{size=+10}Anal Sex:{/size} {size=+10}[mar_anal] | Expert{/size}"
        if mar_anal > 12: # 13
            text "{size=+10}Anal Sex:{/size} {size=+10}[mar_anal] | Professional{/size}"



    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if mar_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if mar_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")
        vbox:
            xalign 0.5
            yalign 0.4
            if mar_cum < 10:
                text ("{color=#474747}puta trga leche{/color}")
            if mar_cum > 9:
                text ("{color=#FFFFFF}puta trga leche{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if mar_blowjobs < 10:
                text ("{color=#474747}Professional Cocksucker{/color}")
            if mar_blowjobs > 9:
                text ("{color=#FFFFFF}Professional Cocksucker{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if mar_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if mar_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")
        #    vbox:
        #        xalign 0.778 ypos 545
        #        if mar_boobjobs < 13:
        #            text ("{color=#474747}Paizuri Star{/color}")
        #        if mar_boobjobs > 12:
        #            text ("{color=#FFFFFF}Paizuri Star{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if mar_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if mar_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")
        vbox:
            xalign 0.5
            yalign 0.6
            if mar_aff < 15:
                text ("{color=#474747}Enamorada{/color}")
            if mar_aff > 14:
                text ("{color=#FFFFFF}Enamorada{/color}")
        vbox:
            xalign 0.5
            yalign 0.65
            if mar_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if mar_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")
        vbox:
            xalign 0.5
            yalign 0.7
            if mar_sub < 10:
                text ("{color=#474747}Submissive{/color}")
            if mar_sub > 9:
                text ("{color=#FFFFFF}Submissive{/color}")

        vbox:
            xalign 0.5
            yalign 0.75
            if mar_hj < 10:
                text ("{color=#474747}Slick Hands{/color}")
            if mar_hj > 9:
                text ("{color=#FFFFFF}Slick Hands{/color}")


        vbox:
            xalign 0.5
            yalign 0.8
            if mar_anal < 10:
                text ("{color=#474747}Buttslut{/color}")
            if mar_anal > 9:
                text ("{color=#FFFFFF}Buttslut{/color}")

        vbox:
            xalign 0.5
            yalign 0.85
            if mar_cun < 10:
                text ("{color=#474747}Face Sitter{/color}")
            if mar_cun > 9:
                text ("{color=#FFFFFF}Face Sitter{/color}")

style stats_frame:
    background None
    xsize 420
    xoffset 1220



screen botstat():
    add "botstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[bot_friendship]{/size}"


    vbox:
        xpos 50 ypos 525
        if bot_ob < 4: # 0 - 3
            text "{size=+10}Obediencia:{/size} {size=+10}[bot_ob] | Extraño{/size}"
        if bot_ob > 3 and bot_ob < 7: #4 - 6
            text "{size=+10}Obediencia:{/size} {size=+10}[bot_ob] | Le gustó{/size}"
        if bot_ob >6 and bot_ob < 10: # 7 - 9
            text "{size=+10}Obediencia:{/size} {size=+10}[bot_ob] | Amigos{/size}"
        if bot_ob > 9 and bot_ob < 13: #10 - 12
            text "{size=+10}Obediencia:{/size} {size=+10}[bot_ob] | Obedient{/size}"
        if bot_ob > 12: #13
            text "{size=+10}Obediencia:{/size} {size=+10}[bot_ob] | Complete Obedience{/size}"

    vbox:
        xpos 50 ypos 570
        text "{size=+10}Parts:{/size} {size=+10}[bot_parts]/3{/size}"

    vbox:
        xpos 50 ypos 660
        if bot_ex < 4: # 0 - 3
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[bot_ex] | Indiferente{/size}"
        if bot_ex > 3 and bot_ex < 7: #4 - 6
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[bot_ex] | Questionable{/size}"
        if bot_ex >6 and bot_ex < 10: # 7 - 9
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[bot_ex] | Nerviosa{/size}"
        if bot_ex > 9 and bot_ex < 13: #10 - 12
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[bot_ex] | Atrevida{/size}"
        if bot_ex > 12: #13
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[bot_ex] | Exhibicionista{/size}"

    vbox:
        xpos 50 ypos 615
        if bot_slut < 4: # 0 - 3
            text "{size=+10}Nivel de puta{/size} {size=+10}[bot_slut] | Pura{/size}"
        if bot_slut > 3 and bot_slut < 7: #4 - 6
            text "{size=+10}Nivel de puta{/size} {size=+10}[bot_slut] | Tainted{/size}"
        if bot_slut >6 and bot_slut < 10: # 7 - 9
            text "{size=+10}Nivel de puta{/size} {size=+10}[bot_slut] | Corrupted{/size}"
        if bot_slut > 9 and bot_slut < 13: #10 - 12
            text "{size=+10}Nivel de puta{/size} {size=+10}[bot_slut] | Putita{/size}"
        if bot_slut > 12: #13
            text "{size=+10}Nivel de puta{/size} {size=+10}[bot_slut] | Puta{/size}"

    vbox:
        if bot_sub < 4: # 0 - 3
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[bot_sub] | Pasiva{/size}"
        if bot_sub > 3 and bot_sub < 7: #4 - 6
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[bot_sub] | Flexible{/size}"
        if bot_sub >6 and bot_sub < 10: # 7 - 9
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[bot_sub] | Servicial{/size}"
        if bot_sub > 9 and bot_sub < 13: #10 - 12
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[bot_sub] | Dutiful{/size}"
        if bot_sub > 12: #13
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[bot_sub] | Obedient{/size}"

    vbox:
        xpos 50 ypos 790
        if bot_hj < 4: # 0 - 3
            text "{size=+10}Handjobs:{/size} {size=+10}[bot_hj] | Inexperta{/size}"
        if bot_hj > 3 and bot_hj < 7: # 4 - 6
            text "{size=+10}Handjobs:{/size} {size=+10}[bot_hj] | experimentada{/size}"
        if bot_hj > 6 and bot_hj < 10: # 7 - 9
            text "{size=+10}Handjobs:{/size} {size=+10}[bot_hj] | Hábil{/size}"
        if bot_hj > 9 and bot_hj < 13: # 10 - 12
            text "{size=+10}Handjobs:{/size} {size=+10}[bot_hj] | Expert{/size}"
        if bot_hj > 12: # 13
            text "{size=+10}Handjobs:{/size} {size=+10}[bot_hj] | Professional{/size}"

    vbox:
        xpos 50 ypos 835
        if bot_boobjobs < 4: # 0 - 3
            text "{size=+10}Boobjobs:{/size} {size=+10}[bot_boobjobs] | Inexperta{/size}"
        if bot_boobjobs > 3 and bot_boobjobs < 7: # 4 - 6
            text "{size=+10}Boobjobs:{/size} {size=+10}[bot_boobjobs] | experimentada{/size}"
        if bot_boobjobs > 6 and bot_boobjobs < 10: # 7 - 9
            text "{size=+10}Boobjobs:{/size} {size=+10}[bot_boobjobs] | Hábil{/size}"
        if bot_boobjobs > 9 and bot_boobjobs < 13: # 10 - 12
            text "{size=+10}Boobjobs:{/size} {size=+10}[bot_boobjobs] | Expert{/size}"
        if bot_boobjobs > 12: # 13
            text "{size=+10}Boobjobs:{/size} {size=+10}[bot_boobjobs] | Professional{/size}"

    vbox:
        xpos 50 ypos 880
        if bot_cun < 4: # 0 - 3
            text "{size=+10}Cunnilingus:{/size} {size=+10}[bot_cun] | Inexperta{/size}"
        if bot_cun > 3 and bot_cun < 7: # 4 - 6
            text "{size=+10}Cunnilingus:{/size} {size=+10}[bot_cun] | experimentada{/size}"
        if bot_cun > 6 and bot_cun < 10: # 7 - 9
            text "{size=+10}Cunnilingus:{/size} {size=+10}[bot_cun] | Hábil{/size}"
        if bot_cun > 9 and bot_cun < 13: # 10 - 12
            text "{size=+10}Cunnilingus:{/size} {size=+10}[bot_cun] | Expert{/size}"
        if bot_cun > 12: # 13
            text "{size=+10}Cunnilingus:{/size} {size=+10}[bot_cun] | Professional{/size}"

    vbox:
        xpos 50 ypos 925
        if bot_sex < 4: # 0 - 3
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[bot_sex] | Inexperta{/size}"
        if bot_sex > 3 and bot_sex < 7: # 4 - 6
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[bot_sex] | experimentada{/size}"
        if bot_sex > 6 and bot_sex < 10: # 7 - 9
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[bot_sex] | Hábil{/size}"
        if bot_sex > 9 and bot_sex < 13: # 10 - 12
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[bot_sex] | Expert{/size}"
        if bot_sex > 12: # 13
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[bot_sex] | Professional{/size}"

    vbox:
        xpos 50 ypos 970
        if bot_anal < 4: # 0 - 3
            text "{size=+10}Anal Sex:{/size} {size=+10}[bot_anal] | Inexperta{/size}"
        if bot_anal > 3 and bot_anal < 7: # 4 - 6
            text "{size=+10}Anal Sex:{/size} {size=+10}[bot_anal] | experimentada{/size}"
        if bot_anal > 6 and bot_anal < 10: # 7 - 9
            text "{size=+10}Anal Sex:{/size} {size=+10}[bot_anal] | Hábil{/size}"
        if bot_anal > 9 and bot_anal < 13: # 10 - 12
            text "{size=+10}Anal Sex:{/size} {size=+10}[bot_anal] | Expert{/size}"
        if bot_anal > 12: # 13
            text "{size=+10}Anal Sex:{/size} {size=+10}[bot_anal] | Professional{/size}"


    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if bot_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if bot_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")
        vbox:
            xalign 0.5
            yalign 0.4
            if bot_cum < 10:
                text ("{color=#474747}puta trga leche{/color}")
            if bot_cum > 9:
                text ("{color=#FFFFFF}puta trga leche{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if bot_boobjobs < 10:
                text ("{color=#474747}Paizuri Star{/color}")
            if bot_boobjobs > 9:
                text ("{color=#FFFFFF}Paizuri Star{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if bot_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if bot_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if bot_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if bot_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")

        vbox:
            xalign 0.5
            yalign 0.6
            if bot_ob < 20:
                text ("{color=#474747}Leal{/color}")
            if bot_ob > 19:
                text ("{color=#FFFFFF}Leal{/color}")

        vbox:
            xalign 0.5
            yalign 0.65
            if bot_sub < 10:
                text ("{color=#474747}Submissive{/color}")
            if bot_sub > 9:
                text ("{color=#FFFFFF}Submissive{/color}")

        vbox:
            xalign 0.5
            yalign 0.7
            if bot_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if bot_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")

        vbox:
            xalign 0.5
            yalign 0.75
            if bot_cun < 10:
                text ("{color=#474747}Face Sitter{/color}")
            if bot_cun > 9:
                text ("{color=#FFFFFF}Face Sitter{/color}")

        vbox:
            xalign 0.5
            yalign 0.8
            if bot_hj < 10:
                text ("{color=#474747}Slick Hands{/color}")
            if bot_hj > 9:
                text ("{color=#FFFFFF}Slick Hands{/color}")

        vbox:
            xalign 0.5
            yalign 0.85
            if bot_anal < 10:
                text ("{color=#474747}Buttslut{/color}")
            if bot_anal > 9:
                text ("{color=#FFFFFF}Buttslut{/color}")


screen linstat():
    add "linstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[lin_friendship]{/size}"



    vbox:
        if lin_ob < 4: # 0 - 3
            xpos 50 ypos 525
            text "{size=+10}Obediencia:{/size} {size=+10}[lin_ob] | Extraño{/size}"
        if lin_ob > 3 and lin_ob < 7: #4 - 6
            xpos 50 ypos 525
            text "{size=+10}Obediencia:{/size} {size=+10}[lin_ob] | Le gustó{/size}"
        if lin_ob >6 and lin_ob < 10: # 7 - 9
            xpos 50 ypos 525
            text "{size=+10}Obediencia:{/size} {size=+10}[lin_ob] | Amigos{/size}"
        if lin_ob > 9 and lin_ob < 13: #10 - 12
            xpos 50 ypos 525
            text "{size=+10}Obediencia:{/size} {size=+10}[lin_ob] | Obedient{/size}"
        if lin_ob > 12: #13
            xpos 50 ypos 525
            text "{size=+10}Obediencia:{/size} {size=+10}[lin_ob] | Complete Obedience{/size}"

    vbox:
        if lin_slut < 4: # 0 - 3
            xpos 50 ypos 615
            text "{size=+10}Nivel de puta{/size} {size=+10}[lin_slut] | Pura{/size}"
        if lin_slut > 3 and lin_slut < 7: #4 - 6
            xpos 50 ypos 615
            text "{size=+10}Nivel de puta{/size} {size=+10}[lin_slut] | Tainted{/size}"
        if lin_slut >6 and lin_slut < 10: # 7 - 9
            xpos 50 ypos 615
            text "{size=+10}Nivel de puta{/size} {size=+10}[lin_slut] | Corrupted{/size}"
        if lin_slut > 9 and lin_slut < 13: #10 - 12
            xpos 50 ypos 615
            text "{size=+10}Nivel de puta{/size} {size=+10}[lin_slut] | Putita{/size}"
        if lin_slut > 12: #13
            xpos 50 ypos 615
            text "{size=+10}Nivel de puta{/size} {size=+10}[lin_slut] | Puta{/size}"

    vbox:
        if linlust < 3:
            xpos 50 ypos 570
            text "{size=+10}Lujuria:{/size} {size=+10}[linlust] | No cachonda{/size}"
        if linlust > 2 and linlust < 5:
            xpos 50 ypos 570
            text "{size=+10}Lujuria:{/size} {size=+10}[linlust] | cachonda{/size}"
        if linlust > 4:
            xpos 50 ypos 570
            text "{size=+10}Lujuria:{/size} {size=+10}[linlust] | Lujuria desbordante{/size}"

    vbox:
        if lin_ex < 4: # 0 - 3
            xpos 50 ypos 660
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[lin_ex] | Indiferente{/size}"
        if lin_ex > 3 and lin_ex < 7: #4 - 6
            xpos 50 ypos 660
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[lin_ex] | Questionable{/size}"
        if lin_ex >6 and lin_ex < 10: # 7 - 9
            xpos 50 ypos 660
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[lin_ex] | Nerviosa{/size}"
        if lin_ex > 9 and lin_ex < 13: #10 - 12
            xpos 50 ypos 660
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[lin_ex] | Atrevida{/size}"
        if lin_ex > 12: #13
            xpos 50 ypos 660
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[lin_ex] | Exhibicionista{/size}"

    vbox:
        if lin_sub < 4: # 0 - 3
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[lin_sub] | Pasiva{/size}"
        if lin_sub > 3 and lin_sub < 7: #4 - 6
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[lin_sub] | Flexible{/size}"
        if lin_sub >6 and lin_sub < 10: # 7 - 9
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[lin_sub] | Servicial{/size}"
        if lin_sub > 9 and lin_sub < 13: #10 - 12
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[lin_sub] | Dutiful{/size}"
        if lin_sub > 12: #13
            xpos 50 ypos 705
            text "{size=+10}Submission:{/size} {size=+10}[lin_sub] | Obedient{/size}"

    vbox:
        xpos 50 ypos 790
        if lin_fj < 4:
            text "{size=+15}Footjobs:{/size} {size=+10}[lin_fj] | Inexperta{/size}"
        if lin_fj > 3 and lin_fj < 7:
            text "{size=+15}Footjobs:{/size} {size=+10}[lin_fj] | experimentada{/size}"
        if lin_fj > 6 and lin_fj < 10:
            text "{size=+15}Footjobs:{/size} {size=+10}[lin_fj] | Hábil{/size}"
        if lin_fj > 9 and lin_fj < 13:
            text "{size=+15}Footjobs:{/size} {size=+10}[lin_fj] | Expert{/size}"
        if lin_fj > 12:
            text "{size=+15}Footjobs:{/size} {size=+10}[lin_fj] | Professional{/size}"

    vbox:
        xpos 50 ypos 835
        if lin_hj < 4:
            text "{size=+15}Handjobs:{/size} {size=+10}[lin_hj] | Inexperta{/size}"
        if lin_hj > 3 and lin_hj < 7:
            text "{size=+15}Handjobs:{/size} {size=+10}[lin_hj] | experimentada{/size}"
        if lin_hj > 6 and lin_hj < 10:
            text "{size=+15}Handjobs:{/size} {size=+10}[lin_hj] | Hábil{/size}"
        if lin_hj > 9 and lin_hj < 13:
            text "{size=+15}Handjobs:{/size} {size=+10}[lin_hj] | Expert{/size}"
        if lin_hj > 12:
            text "{size=+15}Handjobs:{/size} {size=+10}[lin_hj] | Professional{/size}"

    vbox:
        xpos 50 ypos 880
        if lin_blowjobs < 4:
            text "{size=+15}Mamadas:{/size} {size=+10}[lin_blowjobs] | Inexperta{/size}"
        if lin_blowjobs > 3 and lin_blowjobs < 7: # 4 - 6
            text "{size=+15}Mamadas:{/size} {size=+10}[lin_blowjobs] | experimentada{/size}"
        if lin_blowjobs > 6 and lin_blowjobs < 10: # 7 - 9
            text "{size=+15}Mamadas:{/size} {size=+10}[lin_blowjobs] | Hábil{/size}"
        if lin_blowjobs > 9 and lin_blowjobs < 13: # 10 - 12
            text "{size=+15}Mamadas:{/size} {size=+10}[lin_blowjobs] | Expert{/size}"
        if lin_blowjobs > 12:
            text "{size=+15}Mamadas:{/size} {size=+10}[lin_blowjobs] | Professional{/size}"
    vbox:
        xpos 50 ypos 925
        if lin_sex < 4: # 0 - 3
            text "{size=+15}Vaginal Sex:{/size} {size=+10}[lin_sex] | Inexperta{/size}"
        if lin_sex > 3 and lin_sex < 7: # 4 - 6
            text "{size=+15}Vaginal Sex:{/size} {size=+10}[lin_sex] | experimentada{/size}"
        if lin_sex > 6 and lin_sex < 10: # 7 - 9
            text "{size=+15}Vaginal Sex:{/size} {size=+10}[lin_sex] | Hábil{/size}"
        if lin_sex > 9 and lin_sex < 13: # 10 - 12
            text "{size=+15}Vaginal Sex:{/size} {size=+10}[lin_sex] | Expert{/size}"
        if lin_sex > 12: # 13
            text "{size=+15}Vaginal Sex:{/size} {size=+10}[lin_sex] | Professional{/size}"
    vbox:
        xpos 50 ypos 970
        if lin_anal < 4: # 0 - 3
            text "{size=+15}Anal Sex:{/size} {size=+10}[lin_anal] | Inexperta{/size}"
        if lin_anal > 3 and lin_anal < 7: # 4 - 6
            text "{size=+15}Anal Sex:{/size} {size=+10}[lin_anal] | experimentada{/size}"
        if lin_anal > 6 and lin_anal < 10: # 7 - 9
            text "{size=+15}Anal Sex:{/size} {size=+10}[lin_anal] | Hábil{/size}"
        if lin_anal > 9 and lin_anal < 13: # 10 - 12
            text "{size=+15}Anal Sex:{/size} {size=+10}[lin_anal] | Expert{/size}"
        if lin_anal > 12: # 13
            text "{size=+15}Anal Sex:{/size} {size=+10}[lin_anal] | Professional{/size}"


    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if lin_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if lin_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")
        vbox:
            xalign 0.5
            yalign 0.4
            if lin_cum < 10:
                text ("{color=#474747}puta trga leche{/color}")
            if lin_cum > 9:
                text ("{color=#FFFFFF}puta trga leche{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if lin_blowjobs < 10:
                text ("{color=#474747}Professional Cocksucker{/color}")
            if lin_blowjobs > 9:
                text ("{color=#FFFFFF}Professional trga leche{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if lin_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if lin_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if lin_anal < 10:
                text ("{color=#474747}Buttslut{/color}")
            if lin_anal > 9:
                text ("{color=#FFFFFF}Buttslut{/color}")
        vbox:
            xalign 0.5
            yalign 0.6
            if lin_hj < 10:
                text ("{color=#474747}Slick Hands{/color}")
            if lin_hj > 9:
                text ("{color=#FFFFFF}Slick Hands{/color}")
        vbox:
            xalign 0.5
            yalign 0.65
            if lin_ob < 20:
                text ("{color=#474747}Leal{/color}")
            if lin_ob > 19:
                text ("{color=#FFFFFF}Leal{/color}")
        vbox:
            xalign 0.5
            yalign 0.7
            if lin_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if lin_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")
        vbox:
            xalign 0.5
            yalign 0.75
            if lin_sub < 10:
                text ("{color=#474747}Submissive{/color}")
            if lin_sub > 9:
                text ("{color=#FFFFFF}Submissive{/color}")

        vbox:
            xalign 0.5
            yalign 0.8
            if lin_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if lin_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")

        vbox:
            xalign 0.5
            yalign 0.85
            if lin_fj < 10:
                text ("{color=#474747}fetiche de pies{/color}")
            if lin_fj > 9:
                text ("{color=#FFFFFF}fetiche de pies{/color}")


screen viostat():
    add "viostats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[vio_friendship]{/size}"


    vbox:
        xpos 50 ypos 525
        if vio_aff < 4: # 0 - 3
            text "{size=+10}Afecto:{/size} {size=+10}[vio_aff] | Extraño{/size}"
        if vio_aff > 3 and vio_aff < 7: #4 - 6
            text "{size=+10}Afecto:{/size} {size=+10}[vio_aff] | Conocidos{/size}"
        if vio_aff >6 and vio_aff < 10: # 7 - 9
            text "{size=+10}Afecto:{/size} {size=+10}[vio_aff] | Amigos{/size}"
        if vio_aff > 9 and vio_aff < 13: #10 - 12
            text "{size=+10}Afecto:{/size} {size=+10}[vio_aff] | Amigos cercanos{/size}"
        if vio_aff > 12: #13
            text "{size=+10}Afecto:{/size} {size=+10}[vio_aff] | Amantes{/size}"
    vbox:
        xpos 50 ypos 570
        if vio_vor < 4: # 0 - 3
            text "{size=+10}Voracity:{/size} {size=+10}[vio_vor]{/size}"
    vbox:
        xpos 50 ypos 615
        if vio_ex < 4: # 0 - 3
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[vio_ex] | Indiferente{/size}"
        if vio_ex > 3 and vio_ex < 7: #4 - 6
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[vio_ex] | Questionable{/size}"
        if vio_ex >6 and vio_ex < 10: # 7 - 9
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[vio_ex] | Nerviosa{/size}"
        if vio_ex > 9 and vio_ex < 13: #10 - 12
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[vio_ex] | Atrevida{/size}"
        if vio_ex > 12: #13
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[vio_ex] | Exhibicionista{/size}"



    vbox:
        if vio_sex < 4: # 0 - 3
            xpos 50 ypos 745
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[vio_sex] | Inexperta{/size}"
        if vio_sex > 3 and vio_sex < 7: # 4 - 6
            xpos 50 ypos 745
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[vio_sex] | experimentada{/size}"
        if vio_sex > 6 and vio_sex < 10: # 7 - 9
            xpos 50 ypos 745
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[vio_sex] | Hábil{/size}"
        if vio_sex > 9 and vio_sex < 13: # 10 - 12
            xpos 50 ypos 745
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[vio_sex] | Expert{/size}"
        if vio_sex > 12: # 13
            xpos 50 ypos 745
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[vio_sex] | Professional{/size}"



    frame:
        style_prefix "stats"

        vbox:
            xalign 0.5
            yalign 0.35
            if vio_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if vio_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")

        vbox:
            xalign 0.5
            yalign 0.4
            if vio_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if vio_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if vio_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if vio_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if vio_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if vio_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")




screen felstat():
    add "felstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[twin_friendship]{/size}"


    vbox:
        xpos 50 ypos 525
        if fel_aff < 4: # 0 - 3
            text "{size=+10}Afecto:{/size} {size=+10}[fel_aff] | Extraño{/size}"
        if fel_aff > 3 and fel_aff < 7: #4 - 6
            text "{size=+10}Afecto:{/size} {size=+10}[fel_aff] | Conocidos{/size}"
        if fel_aff >6 and fel_aff < 10: # 7 - 9
            text "{size=+10}Afecto:{/size} {size=+10}[fel_aff] | Amigos{/size}"
        if fel_aff > 9 and fel_aff < 13: #10 - 12
            text "{size=+10}Afecto:{/size} {size=+10}[fel_aff] | Amigos cercanos{/size}"
        if fel_aff > 12: #13
            text "{size=+10}Afecto:{/size} {size=+10}[fel_aff] | Amantes{/size}"


    vbox:
        xpos 50 ypos 570
        if fel_slut < 4: # 0 - 3
            text "{size=+10}Nivel de puta{/size} {size=+10}[fel_slut] | Pura{/size}"
        if fel_slut > 3 and fel_slut < 7: #4 - 6
            text "{size=+10}Nivel de puta{/size} {size=+10}[fel_slut] | Tainted{/size}"
        if fel_slut >6 and fel_slut < 10: # 7 - 9
            text "{size=+10}Nivel de puta{/size} {size=+10}[fel_slut] | Corrupted{/size}"
        if fel_slut > 9 and fel_slut < 13: #10 - 12
            text "{size=+10}Nivel de puta{/size} {size=+10}[fel_slut] | Putita{/size}"
        if fel_slut > 12: #13
            text "{size=+10}Nivel de puta{/size} {size=+10}[fel_slut] | Puta{/size}"

    vbox:
        xpos 50 ypos 615
        if fel_ex < 4: # 0 - 3
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[fel_ex] | Indiferente{/size}"
        if fel_ex > 3 and fel_ex < 7: #4 - 6
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[fel_ex] | Questionable{/size}"
        if fel_ex >6 and fel_ex < 10: # 7 - 9
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[fel_ex] | Nerviosa{/size}"
        if fel_ex > 9 and fel_ex < 13: #10 - 12
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[fel_ex] | Atrevida{/size}"
        if fel_ex > 12: #13
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[fel_ex] | Exhibicionista{/size}"


    vbox:
        xpos 50 ypos 745
        if fel_footjobs < 4: # 0 - 3
            text "{size=+10}Footjobs:{/size} {size=+10}[fel_footjobs] | Inexperta{/size}"
        if fel_footjobs > 3 and fel_footjobs < 7: # 4 - 6
            text "{size=+10}Footjobs:{/size} {size=+10}[fel_footjobs] | experimentada{/size}"
        if fel_footjobs > 6 and fel_footjobs < 10: # 7 - 9
            text "{size=+10}Footjobs:{/size} {size=+10}[fel_footjobs] | Hábil{/size}"
        if fel_footjobs > 9 and fel_footjobs < 13: # 10 - 12
            text "{size=+10}Footjobs:{/size} {size=+10}[fel_footjobs] | Expert{/size}"
        if fel_footjobs > 12: # 13
            text "{size=+10}Footjobs:{/size} {size=+10}[fel_footjobs] | Professional{/size}"


    vbox:
        xpos 50 ypos 790
        if fel_sex < 4: # 0 - 3
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[fel_sex] | Inexperta{/size}"
        if fel_sex > 3 and fel_sex < 7: # 4 - 6
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[fel_sex] | experimentada{/size}"
        if fel_sex > 6 and fel_sex < 10: # 7 - 9
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[fel_sex] | Hábil{/size}"
        if fel_sex > 9 and fel_sex < 13: # 10 - 12
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[fel_sex] | Expert{/size}"
        if fel_sex > 12: # 13
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[fel_sex] | Professional{/size}"

    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if fel_cum < 10:
                text ("{color=#474747}puta trga leche{/color}")
            if fel_cum > 9:
                text ("{color=#FFFFFF}puta trga leche{/color}")
        vbox:
            xalign 0.5
            yalign 0.4
            if fel_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if fel_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")
        vbox:
            xalign 0.5
            yalign 0.45
            if fel_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if fel_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if fel_aff < 10:
                text ("{color=#474747}Enamorada{/color}")
            if fel_aff > 9:
                text ("{color=#FFFFFF}Enamorada{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if fel_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if fel_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")

        vbox:
            xalign 0.5
            yalign 0.6
            if fel_footjobs < 10:
                text ("{color=#474747}fetiche de pies{/color}")
            if fel_footjobs > 9:
                text ("{color=#FFFFFF}fetiche de pies{/color}")

        vbox:
            xalign 0.5
            yalign 0.65
            if fel_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if fel_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")

screen emstat():
    add "emstats"
    vbox:
        xalign 0.5 ypos 905
        textbutton "{color=#000000}Back{/color}" action Return()

    vbox:
        xalign 0.059 ypos 315
        text "{size=+50}[twin_friendship]{/size}"


    vbox:
        xpos 50 ypos 525
        if em_aff < 4: # 0 - 3
            text "{size=+10}Afecto:{/size} {size=+10}[em_aff] | Extraño{/size}"
        if em_aff > 3 and em_aff < 7: #4 - 6
            text "{size=+10}Afecto:{/size} {size=+10}[em_aff] | Conocidos{/size}"
        if em_aff >6 and em_aff < 10: # 7 - 9
            text "{size=+10}Afecto:{/size} {size=+10}[em_aff] | Amigos{/size}"
        if em_aff > 9 and em_aff < 13: #10 - 12
            text "{size=+10}Afecto:{/size} {size=+10}[em_aff] | Amigos cercanos{/size}"
        if em_aff > 12: #13
            text "{size=+10}Afecto:{/size} {size=+10}[em_aff] | Amantes{/size}"


    vbox:
        xpos 50 ypos 570
        if em_slut < 4: # 0 - 3
            text "{size=+10}Nivel de puta{/size} {size=+10}[em_slut] | Pura{/size}"
        if em_slut > 3 and em_slut < 7: #4 - 6
            text "{size=+10}Nivel de puta{/size} {size=+10}[em_slut] | Tainted{/size}"
        if em_slut >6 and em_slut < 10: # 7 - 9
            text "{size=+10}Nivel de puta{/size} {size=+10}[em_slut] | Corrupted{/size}"
        if em_slut > 9 and em_slut < 13: #10 - 12
            text "{size=+10}Nivel de puta{/size} {size=+10}[em_slut] | Putita{/size}"
        if em_slut > 12: #13
            text "{size=+10}Nivel de puta{/size} {size=+10}[em_slut] | Puta{/size}"

    vbox:
        xpos 50 ypos 615
        if em_ex < 4: # 0 - 3
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[em_ex] | Indiferente{/size}"
        if em_ex > 3 and em_ex < 7: #4 - 6
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[em_ex] | Questionable{/size}"
        if em_ex >6 and em_ex < 10: # 7 - 9
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[em_ex] | Nerviosa{/size}"
        if em_ex > 9 and em_ex < 13: #10 - 12
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[em_ex] | Atrevida{/size}"
        if em_ex > 12: #13
            text "{size=+10}Exhibicionismo:{/size} {size=+10}[em_ex] | Exhibicionista{/size}"




    vbox:
        xpos 50 ypos 745
        if em_handjobs < 4: # 0 - 3
            text "{size=+10}Handjobs:{/size} {size=+10}[em_handjobs] | Inexperta{/size}"
        if em_handjobs > 3 and em_handjobs < 7: # 4 - 6
            text "{size=+10}Handjobs:{/size} {size=+10}[em_handjobs] | experimentada{/size}"
        if em_handjobs > 6 and em_handjobs < 10: # 7 - 9
            text "{size=+10}Handjobs:{/size} {size=+10}[em_handjobs] | Hábil{/size}"
        if em_handjobs > 9 and em_handjobs < 13: # 10 - 12
            text "{size=+10}Handjobs:{/size} {size=+10}[em_handjobs] | Expert{/size}"
        if em_handjobs > 12: # 13
            text "{size=+10}Handjobs:{/size} {size=+10}[em_handjobs] | Professional{/size}"

    vbox:
        xpos 50 ypos 790
        if em_boobjobs < 4: # 0 - 3
            text "{size=+10}Boobjobs:{/size} {size=+10}[em_boobjobs] | Inexperta{/size}"
        if em_boobjobs > 3 and em_boobjobs < 7: # 4 - 6
            text "{size=+10}Boobjobs:{/size} {size=+10}[em_boobjobs] | experimentada{/size}"
        if em_boobjobs > 6 and em_boobjobs < 10: # 7 - 9
            text "{size=+10}Boobjobs:{/size} {size=+10}[em_boobjobs] | Hábil{/size}"
        if em_boobjobs > 9 and em_boobjobs < 13: # 10 - 12
            text "{size=+10}Boobjobs:{/size} {size=+10}[em_boobjobs] | Expert{/size}"
        if em_boobjobs > 12: # 13
            text "{size=+10}Boobjobs:{/size} {size=+10}[em_boobjobs] | Professional{/size}"


    vbox:
        xpos 50 ypos 835
        if em_sex < 4: # 0 - 3
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[em_sex] | Inexperta{/size}"
        if em_sex > 3 and em_sex < 7: # 4 - 6
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[em_sex] | experimentada{/size}"
        if em_sex > 6 and em_sex < 10: # 7 - 9
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[em_sex] | Hábil{/size}"
        if em_sex > 9 and em_sex < 13: # 10 - 12
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[em_sex] | Expert{/size}"
        if em_sex > 12: # 13
            text "{size=+10}Vaginal Sex:{/size} {size=+10}[em_sex] | Professional{/size}"



    frame:
        style_prefix "stats"
        vbox:
            xalign 0.5
            yalign 0.35
            if em_cum < 10:
                text ("{color=#474747}puta trga leche{/color}")
            if em_cum > 9:
                text ("{color=#FFFFFF}puta trga leche{/color}")

        vbox:
            xalign 0.5
            yalign 0.4
            if em_dump < 10:
                text ("{color=#474747}Cumdump{/color}")
            if em_dump > 9:
                text ("{color=#FFFFFF}Cumdump{/color}")

        vbox:
            xalign 0.5
            yalign 0.45
            if em_slut < 10:
                text ("{color=#474747}Mega Puta{/color}")
            if em_slut > 9:
                text ("{color=#FFFFFF}Mega Puta{/color}")
        vbox:
            xalign 0.5
            yalign 0.5
            if em_aff < 10:
                text ("{color=#474747}Enamorada{/color}")
            if em_aff > 9:
                text ("{color=#FFFFFF}Enamorada{/color}")
        vbox:
            xalign 0.5
            yalign 0.55
            if em_ex < 10:
                text ("{color=#474747}Exhibicionista{/color}")
            if em_ex > 9:
                text ("{color=#FFFFFF}Exhibicionista{/color}")

        vbox:
            xalign 0.5
            yalign 0.6
            if em_handjobs < 10:
                text ("{color=#474747}Slick Hands{/color}")
            if em_handjobs > 9:
                text ("{color=#FFFFFF}Slick Hands{/color}")

        vbox:
            xalign 0.5
            yalign 0.65
            if em_sex < 10:
                text ("{color=#474747}Nympho{/color}")
            if em_sex > 9:
                text ("{color=#FFFFFF}Nympho{/color}")

        vbox:
            xalign 0.5
            yalign 0.7
            if em_boobjobs < 10:
                text ("{color=#474747}Paizuri Star{/color}")
            if em_boobjobs > 9:
                text ("{color=#FFFFFF}Paizuri Star{/color}")
















screen kalistats():
    frame:
        xalign 0.5 ypos 200
        vbox:
            text _("Kali's Stats") at truecenter
            text _("_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _")
            text _(" ")
            text _("Amistad: [kali_friendship]")
            text _("Puta: [kali_slut]")
            text _("Afecto: [kali_aff]")
            text _(" ")
            text _("Mamadas: [kali_blowjobs]")
            text _("Vaginal Sex: [kali_sex]")
            text _("Boobjobs: [kali_boobjobs]")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            textbutton _("Back"):
                action [Hide ("kalistats"), Show ("statpage"), Show ("statshide")]


screen ashstatss():
    frame:
        xalign 0.5 ypos 200
        vbox:
            text _("Ashley's Stats") at truecenter
            text _("_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _")
            text _(" ")
            text _("Amistad: [ash_friendship]")
            text _("Puta: [ash_slut]")
            text _("Afecto: [ash_aff]")
            text _(" ")
            text _("Mamadas: [ash_blowjobs]")
            text _("Thighjobs: [ash_thigh]")
            text _("Vaginal Sex: [ash_sex]")
            text _("Anal Sex: [ash_anal1]")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            textbutton _("Back"):
                action [Hide ("ashstats"), Show ("statpage"), Show ("statshide")]

screen linstats():
    frame:
        xalign 0.5 ypos 200
        vbox:
            text _("Lin's Stats") at truecenter
            text _("_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _")
            text _(" ")
            text _("Amistad: [lin_friendship]")
            text _("Obediencia: [lin_ob]")
            text _("Lujuria: [linlust]")
            text _(" ")
            text _("Handjobs: [lin_hj]")
            text _("Mamadas: [lin_blowjobs]")
            text _("Vaginal Sex: [lin_sex]")
            text _("Anal Sex: [lin_anal]")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            textbutton _("Back"):
                action [Hide ("linstats"), Show ("statpage"), Show ("statshide")]

screen marstats():
    frame:
        xalign 0.5 ypos 200
        vbox:
            text _("Maria's Stats") at truecenter
            text _("_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _")
            text _(" ")
            text _("Amistad: [mar_friendship]")
            text _("Puta: [mar_slut]")
            text _("Afecto: [mar_aff]")
            text _(" ")
            text _("Mamadas: [mar_blowjobs]")
            text _("Vaginal Sex: [mar_sex]")
            #text _("Anal Sex: ???")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            textbutton _("Back"):
                action [Hide ("marstats"), Show ("statpage"), Show ("statshide")]

screen botstats():
    frame:
        xalign 0.5 ypos 200
        vbox:
            text _("[botname]'s Stats") at truecenter
            text _("_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _")
            text _(" ")
            text _("Amistad: [bot_friendship]")
            text _("Obediencia: [bot_ob]")
            text _("Upgrades: [bot_parts]/3")
            text _(" ")
            text _("Mamadas: 0")
            text _("Vaginal Sex: [bot_sex]")
            text _("Anal Sex: 0")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            text _(" ")
            textbutton _("Back"):
                action [Hide ("botstats"), Show ("statpage"), Show ("statshide")]







#screen frontdoor():
#    frame:
#        xalign 0.5 ypos 900
#        vbox:
#            #text _("Back")
#            textbutton _("Front Door"):
#                action Jump("frontdoor")

screen frontdoor():
    vbox xalign 0.5 ypos 975:
        imagebutton:
            idle "gui/btn_door.png"
            hover "gui/btn_door_over.png"
            action Jump("frontdoor")


screen frontdoor2():
    vbox xalign 0.5 ypos 975:
        imagebutton:
            idle "gui/btn_door.png"
            hover "gui/btn_door_over.png"
            action Jump("frontdoor2")

#screen advance_time():
#    frame:
#        xalign 0.5 ypos 975
#        vbox:
#            #text _("Back")
#            textbutton _("Advance Time"):
#                action Call("advancetime")


screen advance_time():
    zorder 200
    imagebutton xalign 0.298 ypos 0:
        idle "gui/abtn_forward.png"
        hover "gui/abtn_forward_over.png"
        action Call("advancetime")
screen advance_time_bar():
    zorder 200
    imagebutton xalign 0.298 ypos 0:
        idle "gui/abtn_forward.png"
        hover "gui/abtn_forward_over.png"
        action Call("advancetimebar")

screen time_lock():
    zorder 200
    imagebutton xalign 0.298 ypos 0:
        idle "gui/abtn_forward_lock.png"
        hover "gui/abtn_forward_lock.png"

screen plus():
    frame:
        xalign 0.5 ypos 900
        vbox:
            #text _("Back")
            textbutton _("plus"):
                action Call("plus")



#screen day():
    #frame:
       #xalign 0.5 ypos 0
       #vbox:
            #text _("Day [day] | Time [time_of_day] | [todays] | $[money]")

screen day():
    zorder 100
    vbox:
        xalign 0.5 ypos 0
        image "gui/bar_top_1.png"
        vbox:
            if renpy.variant("pc"):
                xalign 0.84 ypos -83
                text "{color=#0BCA02}$[money]{/color}"
            else:
                ##Android v
                xalign 0.84 ypos -83
                text "{color=#0BCA02}{size=-10}$[money]{/size}{/color}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.28 ypos -71
                text "{size=-13}[todays] Morning{/size}"
            else:
                ##Android v
                xalign 0.27 ypos -76
                text "{size=-20}[todays] Morning{/size}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.180 ypos -125
                text "{b}{color=#000000}{size=-12}[day]{/size}{/color}{/b}"
            else:
                ##Android v
                xalign 0.175 ypos -135
                text "{b}{color=#000000}{size=-20}[day]{/size}{/color}{/b}"


#    frame:
#        xalign 0.5 ypos 0
#        vbox:
#            text _("Day [day] | {color=#00C0E3}[todays] Morning{/color} | {color=#0BCA02}$[money]{/color}")
screen day2():
    zorder 100
    vbox:
        xalign 0.5 ypos 0
        image "gui/bar_top_2.png"
        vbox:
            if renpy.variant("pc"):
                xalign 0.84 ypos -83
                text "{color=#0BCA02}$[money]{/color}"
            else:
            ###Android v
                xalign 0.84 ypos -83
                text "{color=#0BCA02}{size=-10}$[money]{/size}{/color}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.40 ypos -71
                text "{size=-13}[todays] Noon{/size}"
            else:
                ##Android v
                xalign 0.40 ypos -76
                text "{size=-20}[todays] Noon{/size}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.182 ypos -125
                text "{b}{color=#000000}{size=-12}[day]{/size}{/color}{/b}"
            else:
                ##Android v
                xalign 0.175 ypos -135
                text "{b}{color=#000000}{size=-20}[day]{/size}{/color}{/b}"


#    frame:
#        xalign 0.5 ypos 0
#        vbox:
#            text _("Day [day] | {color=#DEDA00}[todays] Noon{/color} | {color=#0BCA02}$[money]{/color}")
screen day3():
    zorder 100
    vbox:
        xalign 0.5 ypos 0
        image "gui/bar_top_3.png"
        vbox:
            if renpy.variant("pc"):
                xalign 0.84 ypos -83
                text "{color=#0BCA02}$[money]{/color}"
            else:
                ##Android v
                xalign 0.84 ypos -83
                text "{color=#0BCA02}{size=-10}$[money]{/size}{/color}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.513 ypos -71
                text "{size=-13}[todays] Evening{/size}"
            else:
                ##Android v
                xalign 0.513 ypos -76
                text "{size=-20}[todays] Evening{/size}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.182 ypos -125
                text "{b}{color=#000000}{size=-12}[day]{/size}{/color}{/b}"
            else:
                ##Android v
                xalign 0.175 ypos -135
                text "{b}{color=#000000}{size=-20}[day]{/size}{/color}{/b}"


#    frame:
#        xalign 0.5 ypos 0
#        vbox:
#            text _("Day [day] | {color=#E77E00}[todays] Afternoon{/color} | {color=#0BCA02}$[money]{/color}")
screen day4():
    zorder 100
    vbox:
        xalign 0.5 ypos 0
        image "gui/bar_top_4.png"
        vbox:
            if renpy.variant("pc"):
                xalign 0.84 ypos -83
                text "{color=#0BCA02}$[money]{/color}"
            else:
                ##Android v
                xalign 0.84 ypos -83
                text "{color=#0BCA02}{size=-10}$[money]{/size}{/color}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.63 ypos -71
                text "{size=-13}[todays] Night{/size}"
            else:
                ##Android v
                xalign 0.63 ypos -76
                text "{size=-20}[todays] Night{/size}"
        vbox:
            if renpy.variant("pc"):
                xalign 0.182 ypos -125
                text "{b}{color=#000000}{size=-12}[day]{/size}{/color}{/b}"
            else:
                ##Android v
                xalign 0.175 ypos -135
                text "{b}{color=#000000}{size=-20}[day]{/size}{/color}{/b}"



#    frame:
#        xalign 0.5 ypos 0
#        vbox:
#            text _("Day [day] | {color=#00589E}[todays] Night{/color} | {color=#0BCA02}$[money]{/color}")





screen kalifriendship():
    frame:
        xalign 0.65 ypos 850
        vbox:
            #text _("Go to sleep"):
            textbutton _("[kali_friendship]")

screen linfriendship():
    frame:
        xalign 0.69 ypos 850
        vbox:
            #text _("Go to sleep"):
            textbutton _("[lin_friendship]")

screen ashfriendship():
    frame:
        xalign 0.73 ypos 850
        vbox:
            #text _("Go to sleep"):
            textbutton _("[ash_friendship]")





screen save():

    tag menu

    use file_slots(_("Save"))


screen load():

    tag menu

    use file_slots(_("Continue"))


screen file_slots(title):

    default page_name_value = FilePageNameInputValue(pattern=_("Page {}"), auto=_("Automatic saves"), quick=_("Quick saves"))

    use game_menu(title):

        fixed:

            ## This ensures the input will get the enter event before any of the
            ## buttons do.
            order_reverse True

            ## Buttons to access other pages.
            hbox:
                style_prefix "page"
                xalign 0.5
                yalign 0.0
                spacing 500

                textbutton _("<") action FilePagePrevious()
                textbutton _(">") action FilePageNext()

            ## The page name, which can be edited by clicking on a button.
            button:
                style "page_label"

                key_events True
                xalign 0.5
                action page_name_value.Toggle()

                input:
                    style "page_label_text"
                    value page_name_value

            ## The grid of file slots.
            vpgrid cols gui.file_slot_cols:
                mousewheel True
                arrowkeys True
                draggable True
                scrollbars "vertical"
                side_xalign 0.0
                ypos 450
                ymaximum 770
                style_prefix "slot"
                xalign 0.5
                yalign 0.5
                spacing gui.slot_spacing

                for i in range(1 * 100):

                    $ slot = i + 1

                    button:
                        action FileAction(slot)

                        has vbox

                        add FileScreenshot(slot) xalign 0.5

                        text FileTime(slot, format=_("{#file_time}%m / %d / %Y, %H:%M"), empty=_("Empty Slot")):
                            style "slot_time_text"

                        text FileSaveName(slot):
                            style "slot_name_text"

                        key "save_delete" action FileDelete(slot)

style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 75

style page_label_text:
    text_align 0.5
    layout "subtitle"
    hover_color gui.hover_color
    outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.button_text_properties("page_button")
    outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.button_text_properties("slot_button")
    outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]


## Preferences screen ##########################################################
##
## The preferences screen allows the player to configure the game to better suit
## themselves.
##
## https://www.renpy.org/doc/html/screen_special.html#preferences

screen preferences():

    tag menu

    use game_menu(_("Options"), scroll="viewport"):

        vbox:

            hbox:
                box_wrap True

                if renpy.variant("pc"):

                    vbox:
                        style_prefix "pref"
                        label _("Language")
                        textbutton "English" action Language(None)
                        textbutton "Spanish" action Language("spanish")

                vbox:
                    style_prefix "radio"
                    label _("Rollback Side")
                    textbutton _("Disable") action Preference("rollback side", "disable")
                    textbutton _("Left") action Preference("rollback side", "left")
                    textbutton _("Right") action Preference("rollback side", "right")

                vbox:
                    style_prefix "check"
                    label _("Skip")
                    textbutton _("Unseen Text") action Preference("skip", "toggle")
                    textbutton _("After Choices") action Preference("after choices", "toggle")
                    textbutton _("Transitions") action InvertSelected(Preference("transitions", "toggle"))

                ## Additional vboxes of type "radio_pref" or "check_pref" can be
                ## added here, to add additional creator-defined preferences.

            null height (4 * gui.pref_spacing)

            hbox:
                style_prefix "slider"
                box_wrap True

                vbox:

                    label _("Text Speed")

                    bar value Preference("text speed")

                    label _("Auto-Forward Time")

                    bar value Preference("auto-forward time")

                vbox:

                    if config.has_music:
                        label _("Music Volume")

                        hbox:
                            bar value Preference("music volume")

                    if config.has_sound:

                        label _("Sound Volume")

                        hbox:
                            bar value Preference("sound volume")

                            if config.sample_sound:
                                textbutton _("Test") action Play("sound", config.sample_sound)


                    #if config.has_voice:
                    #    label _("Voice Volume")
                    #
                    #    hbox:
                    #        bar value Preference("voice volume")
                    #
                    #        if config.sample_voice:
                    #            textbutton _("Test") action Play("voice", config.sample_voice)

                    if config.has_music or config.has_sound or config.has_voice:
                        null height gui.pref_spacing

                        textbutton _("Mute All"):
                            action Preference("all mute", "toggle")
                            style "mute_all_button"


style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style radio_button_text:
    properties gui.button_text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.button_text_properties("check_button")

style slider_slider:
    xsize 525

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 15

style slider_button_text:
    properties gui.button_text_properties("slider_button")

style slider_vbox:
    xsize 675


## History screen ##############################################################
##
## This is a screen that displays the dialogue history to the player. While
## there isn't anything special about this screen, it does have to access the
## dialogue history stored in _history_list.
##
## https://www.renpy.org/doc/html/history.html

screen history():

    tag menu

    ## Avoid predicting this screen, as it can be very large.
    predict False

    use game_menu(_("History"), scroll=("vpgrid" if gui.history_height else "viewport"), yinitial=1.0):

        style_prefix "history"

        for h in _history_list:

            window:

                ## This lays things out properly if history_height is None.
                has fixed:
                    yfit True

                if h.who:

                    label h.who:
                        style "history_name"

                        ## Take the color of the who text from the Character, if
                        ## set.
                        if "color" in h.who_args:
                            text_color h.who_args["color"]

                $ what = renpy.filter_text_tags(h.what, allow=gui.history_allow_tags)
                text what

        if not _history_list:
            label _("The dialogue history is empty.")


## This determines what tags are allowed to be displayed on the history screen.

define gui.history_allow_tags = set()


style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is gui_text

style history_text is gui_text

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    text_align gui.history_name_xalign

style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    text_align gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")

style history_label:
    xfill True

style history_label_text:
    xalign 0.5


## Help screen #################################################################
##
## A screen that gives information about key and mouse bindings. It uses other
## screens (keyboard_help, mouse_help, and gamepad_help) to display the actual
## help.

############screen help():

#    tag menu

#    default device = "keyboard"

#    use game_menu(_("Help"), scroll="viewport"):

#        style_prefix "help"

#        vbox:
#            spacing 23

#            hbox:

#                textbutton _("Keyboard") action SetScreenVariable("device", "keyboard")
#                textbutton _("Mouse") action SetScreenVariable("device", "mouse")

#                if GamepadExists():
#                    textbutton _("Gamepad") action SetScreenVariable("device", "gamepad")

#            if device == "keyboard":
#                use keyboard_help
#            elif device == "mouse":
#                use mouse_help
#            elif device == "gamepad":
#                use gamepad_help


screen keyboard_help():

    hbox:
        label _("Enter")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Space")
        text _("Advances dialogue without selecting choices.")

    hbox:
        label _("Arrow Keys")
        text _("Navigate the interface.")

    hbox:
        label _("Escape")
        text _("Accesses the game menu.")

    hbox:
        label _("Ctrl")
        text _("Skips dialogue while held down.")

    hbox:
        label _("Tab")
        text _("Toggles dialogue skipping.")

    hbox:
        label _("Page Up")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Page Down")
        text _("Rolls forward to later dialogue.")

    hbox:
        label "H"
        text _("Hides the user interface.")

    hbox:
        label "S"
        text _("Takes a screenshot.")

    hbox:
        label "V"
        text _("Toggles assistive {a=https://www.renpy.org/l/voicing}self-voicing{/a}.")


screen mouse_help():

    hbox:
        label _("Left Click")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Middle Click")
        text _("Hides the user interface.")

    hbox:
        label _("Right Click")
        text _("Accesses the game menu.")

    hbox:
        label _("Mouse Wheel Up\nClick Rollback Side")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Mouse Wheel Down")
        text _("Rolls forward to later dialogue.")


screen gamepad_help():

    hbox:
        label _("Right Trigger\nA/Bottom Button")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Left Trigger\nLeft Shoulder")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Right Shoulder")
        text _("Rolls forward to later dialogue.")


    hbox:
        label _("D-Pad, Sticks")
        text _("Navigate the interface.")

    hbox:
        label _("Start, Guide")
        text _("Accesses the game menu.")

    hbox:
        label _("Y/Top Button")
        text _("Hides the user interface.")

    textbutton _("Calibrate") action GamepadCalibrate()


style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 12

style help_button_text:
    properties gui.button_text_properties("help_button")

style help_label:
    xsize 375
    right_padding 30

style help_label_text:
    size gui.text_size
    xalign 1.0
    text_align 1.0



################################################################################
## Additional screens
################################################################################


## Confirm screen ##############################################################
##
## The confirm screen is called when Ren'Py wants to ask the player a yes or no
## question.
##
## https://www.renpy.org/doc/html/screen_special.html#confirm

screen confirm(message, yes_action, no_action):

    ## Ensure other screens do not get input while this screen is displayed.
    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/confirm.png"

    frame:

        vbox:
            xalign .5
            yalign .5
            spacing 45

            label _(message):
                style "confirm_prompt"
                xalign 0.5

            hbox:
                xalign 0.5
                spacing 150

                textbutton _("Yes") action yes_action
                textbutton _("No") action no_action

    ## Right-click and escape answer "no".
    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    text_align 0.5
    layout "subtitle"

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.button_text_properties("confirm_button")


## Skip indicator screen #######################################################
##
## The skip_indicator screen is displayed to indicate that skipping is in
## progress.
##
## https://www.renpy.org/doc/html/screen_special.html#skip-indicator

screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        hbox:
            spacing 9

            text _("Skipping")

            text "â–¸" at delayed_blink(0.0, 1.0) style "skip_triangle"
            text "â–¸" at delayed_blink(0.2, 1.0) style "skip_triangle"
            text "â–¸" at delayed_blink(0.4, 1.0) style "skip_triangle"


## This transform is used to blink the arrows one after another.
transform delayed_blink(delay, cycle):
    alpha .5

    pause delay

    block:
        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:
    ## We have to use a font that has the BLACK RIGHT-POINTING SMALL TRIANGLE
    ## glyph in it.
    font "DejaVuSans.ttf"


## Notify screen ###############################################################
##
## The notify screen is used to show the player a message. (For example, when
## the game is quicksaved or a screenshot has been taken.)
##
## https://www.renpy.org/doc/html/screen_special.html#notify-screen

screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text "[message!tq]"

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    properties gui.text_properties("notify")


## NVL screen ##################################################################
##
## This screen is used for NVL-mode dialogue and menus.
##
## https://www.renpy.org/doc/html/screen_special.html#nvl


screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            spacing gui.nvl_spacing

        ## Displays dialogue in either a vpgrid or the vbox.
        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)

        ## Displays the menu, if given. The m may be displayed incorrectly if
        ## config.narrator_m is set to True, as it is above.
        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0


screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            fixed:
                yfit gui.nvl_height is None

                if d.who is not None:

                    text d.who:
                        id d.who_id

                text d.what:
                    id d.what_id


## This controls the maximum number of NVL-mode entries that can be displayed at
## once.
define config.nvl_list_length = gui.nvl_list_length

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    text_align gui.nvl_name_xalign

style nvl_dialogue:
    xpos gui.nvl_text_xpos
    xanchor gui.nvl_text_xalign
    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    text_align gui.nvl_text_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_thought:
    xpos gui.nvl_thought_xpos
    xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    text_align gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.button_text_properties("nvl_button")



################################################################################
## Mobile Variants
################################################################################

style pref_vbox:
    variant "medium"
    xsize 675

## Since a mouse may not be present, we replace the quick m with a version
## that uses fewer and bigger buttons that are easier to touch.
screen quick_menu():
    variant "touch"

    zorder 100

    if quick_menu:
        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Back") action Rollback()
            textbutton _("Skip") action Skip() alternate Skip(fast=True, confirm=True)
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Menu") action ShowMenu()


style window:
    variant "small"
    background "gui/phone/textbox.png"


#style window:
#    variant "touch"
#    background "gui/phone/textbox.png"

style radio_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style check_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
    #background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 510

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 600

style bar:
    variant "small"
    ysize gui.bar_size
    left_bar Frame("gui/phone/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/phone/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    variant "small"
    xsize gui.bar_size
    top_bar Frame("gui/phone/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/phone/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    variant "small"
    ysize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    variant "small"
    xsize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    variant "small"
    ysize gui.slider_size
    base_bar Frame("gui/phone/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/horizontal_[prefix_]thumb.png"

style vslider:
    variant "small"
    xsize gui.slider_size
    base_bar Frame("gui/phone/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/vertical_[prefix_]thumb.png"

style slider_pref_vbox:
    variant "small"
    xsize None

style slider_pref_slider:
    variant "small"
    xsize 900
