#########
# Ren'Py will automatically call this label if the player clicks history button,
# but the game has no history (a menu item named history is missing).
label history_screen:
    show screen game_has_no_history
    $ renpy.pause(2)
    hide screen game_has_no_history
    return
# This is the message 
screen game_has_no_history():
    vbox:
        xalign 0.5
        yalign 0.5
        text "This game has no history screen, sorry!":
            style "say_dialogue"
            

# Ren'Py init section
init 999:

    #########
    ## quick menu redesign
    
    screen quick_menu():
    
        # Bind Alt+Shift+M to toggle Quick Menu, set suppress_overlay to False no matter what
        
        key "alt_K_m" action [ If(suppress_overlay, SetVariable('quick_menu', True ), If(quick_menu, SetVariable('quick_menu', False ), SetVariable('quick_menu', True ))), SetVariable('suppress_overlay', False ) ]
        
        zorder 100
        if quick_menu:
            hbox:
                style_prefix "quick"
                xalign 1.0
                yalign 1.0
                textbutton _("◀-|") action Rollback() xpos -40
                textbutton _("▶▶") action Skip() alternate Skip(fast=True, confirm=True) xpos -30
                if _preferences.afm_enable:
                    textbutton _("a ■") action Preference("auto-forward", "disable") xpos -20 # display stop button when enabled
                else :
                    textbutton _("a ▶") action Preference("auto-forward", "enable") xpos -20 # display play button when disabled
                textbutton ("▼") action If(renpy.get_screen("say"), HideInterface(), None) xoffset -10
            hbox:
                style_prefix "quick"
                xalign 0.0025
                yalign 1.0
                textbutton _("Hist") action ShowMenu('history')
                textbutton _("Save") action ShowMenu('save')
                textbutton _("Load") action ShowMenu('load')
                textbutton _("Q.S") action QuickSave()
                textbutton _("Q.L") action QuickLoad()
                textbutton _("Prefs") action ShowMenu('preferences')

    #########
    ## text box text outline (black) and color (white)
    style say_dialogue:
        color "#FFFFFF"
        outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
        
    #########
    ## name box text outline
    style say_label:
        outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
    
    #########
    ## input prompt text style
    style input_prompt:
        color "#FFFFFF"
        outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
    
    #########
    ## input text style
    style input:
        color "#FFFFFF"
        outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
        
    #########
    ## choice button text style
    style choice_button_text:
        size style.say_dialogue.size
        #font "DejaVuSans.ttf"
        idle_color "#FFF"
        hover_color "#00FF00"
        insensitive_color "#808080FF"
        idle_outlines [ (absolute(5), "#FFF0", absolute(1), absolute(1)), (absolute(2), "#000", absolute(1), absolute(1)) ]
        hover_outlines [ (absolute(5), "#0F08", absolute(1), absolute(1)), (absolute(2), "#000", absolute(1), absolute(1)) ]
        insensitive_outlines [ (absolute(5), "#808080C0", absolute(1), absolute(1)), (absolute(2), "#000", absolute(1), absolute(1)) ]
        
    #########
    ## choice menu style
    #style menu_choice:
    #    is default
    #    color "#FFFFFF"
    #    idle_color "#FFFFFF"
    #    hover_color "#00FF00"
    #    insensitive_color "#808080"
    #    outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
        
    #########
    ## quick menu button text style
    style quick_button_text:
        font "DejaVuSans.ttf"
        size 18
        idle_color "#8885"
        hover_color "#0F0F"
        insensitive_color "#4445"
        outlines [ (absolute(1), "#000A", absolute(0), absolute(0)) ]
        hover_outlines [ (absolute(1), "#000F", absolute(0), absolute(0)) ]

    #########
    ## quick menu button style        
    style quick_button:
        is default
        xpadding 5
        
    #########
    ## text box background
    style window:
        background None

    #########
    ## name box background
    style namebox:
        background None
        
    #########
    ## choice button background
    style choice_button:
        background None

    #########
    ## enable quick menu
    $ quick_menu = True
    $ suppress_overlay = False
        
    #########
    ## Game-specific overrides

    ######### View of Family - the latest version tested: v0.1.1
    ## Overriding MC's character text color and outline defined via what_color and what_outline in script.rpy
    ## Removing background from the choice menu window
    if config.name == "View of family":
        define y = DynamicCharacter("povname", color="#000080")
        screen choice(items):
            style_prefix "choice"
            vbox:
                for i in items:
                    textbutton i.caption action i.action
        
    ######### Dual Family [Gumdrop Games] - the latest version tested: v0.98ce
    ## Removing all of the what_color and what_outline settings
    if config.name == "Dual Family":
        define ps = DynamicCharacter("ps_name", color="#faff70")
        define m = DynamicCharacter("m_name", color="#c579fc") 
        define x = DynamicCharacter("x_name", color="#ffbcbc")  
        define f = DynamicCharacter("f_name", color="#5998ff")  
        define pf = DynamicCharacter("pf_name", color="#5998ff")  
        define d = DynamicCharacter("d_name", color="#ffaddb")
        define w = DynamicCharacter("w_name", color="#c579fc")
        define s = DynamicCharacter("s_name", color="#faff70")
        define a = DynamicCharacter ("a_name", color="#4fe57a")
        define l = DynamicCharacter ("l_name", color="#4fe57a")
        define n = DynamicCharacter ("n_name", color="#d13cb8")
        define q = DynamicCharacter ("q_name", color="#d13cb8")
        define mu = Character("", color="#c579fc")
        define fu = Character("", color="#5998ff")
        define w2 = DynamicCharacter("w_name", color="#c579fc")
        define m1 = Character("", color="#c579fc")
        define du = Character("", color="#ffaddb")
        define sk = Character("Skeleton", color="#fff")
        define k = Character ("Karen", color="#d13cb8")
        define k2 = Character ("", color="#d13cb8")
        define g1 = Character ("Ghoulish Girl", color="#bcddff")
        define g2 = Character ("Jawsome Girl", color="#d1a22e")
        define r = Character ("Redhead Girl", color="#ff6d6d")
        define o = Character ("Sultry Girl", color="#5e37cc")
        define h = Character ("Hoodie Girl", color="#5cd6b3")
        define i = Character ("Isaac", color="#a00000")
        define c = Character ("Cashier", color="#a00000")
        define b = Character ("Ben", color="#ffb459")
        define b2 = Character ("", color="#ffb459")
        define l2 = Character ("", color="#4fe57a")
        define h2 = Character ("", color="#5cd6b3")
        define r2 = Character ("", color="#ff6d6d")
        define ha = Character ("Mara", color="#5cd6b3")
        define ra = Character ("Maddy", color="#ff6d6d")
        define ho = Character ("Hostess", color="#700024")
        
    ######### Au-pair Innocence SE [Alex] - the latest version tested: v0.9
    ## Removing all of the what_color and what_outline settings
    ## If you prefer to keep these colors, just change the value that config.name variable is compared to
    ## on the next line from "Au-pair innocence SE" to "Au-pair innocence SEabcdefg" for example. Save this file, reload game.
    if config.name == "Au-pair innocence SE":
        define t = Character('Tasha', color="#ff5353", image = 'tasha')
        define a = Character('Alex', color="#f0ff00", image = 'alex')
        define f = Character('David', color="#fcc863", image ='david')
        define ala = Character("Ala", color="#c354f7", image ='ala')
        define k = Character("Kevin", color="#9ccd3d", image ='kevin')
        define ta = Character("Tanya", color="#48d877", image ='tanya')
        define o = Character("Oliver", color="#28d9ff", image ='oliver')
        define c = Character('Charlotte', color="#ebf239", image ='charlotte')
        define co = Character('Conor', color="#99c7ff", image ='conor') 
        define ma = Character('Mark', color="#59c7ff", image ='mark')
        define j = Character('Jake', color="#75c700", image ='jake')
    
    ######### Life [Fasder] - the latest version tested: v0.06.03
    ######### Thinking About You [Noir Desir] - the latest version tested: v0.2
    ######### Indecent Desires [Vilelab] - 0.1
    ## Making the the text easier to read in the dialog box by changing the font to Ren'Py default DejaVu Sans.
    if config.name == "Life" or config.name == "Thinking About You" or config.name == "Indecent Desires":
        style say_dialogue:
            font "DejaVuSans.ttf"
    
    ######### Life With Pleasure [] - the latest version tested: v0.3
    ## Overriding dialogue text with Ren'Py default (DejaVu Sans)
    ## Since the game font was smaller than default, the size was also enlarged
    if build.name == "LifeWithPlesuare" or build.name == "LifeWithPleasure":
        style say_dialogue:
            font "DejaVuSans.ttf"
        define gui.text_size = 30
            
    ######### Where The Heart Is [CheekyGimp] - the latest version tested: EP9
    ## Removing all the partially transparent character text boxes. Like I said, I don't like boxes
    ## covering the picture, even when they're partially transparent. The loss of a static character portrait
    ## with it isn't much of a loss anyway. 
    if config.name == "Where The Heart Is":
        define A = Character('Angel', color="#c8ffc8")
        define B = Character('Bella', color="#a22a10")
        define C = Character('Jolina', color="#927e74")
        define CH = Character('Chad', color="#fda948")
        define D = Character('Debbie', color="#b5287f")
        define E = Character('Elaine', color="#c8ffc8")
        define G = Character('Greg', color="#939941")
        define F = Character('Francois', color="#939941")
        define FI = Character('Fiona', color="#e12421")
        define I = Character("[player_name]", color="#ffffff")
        define J = Character('Jenna', color="#fda948")
        define K = Character('Katie', color="#9f8fcc")
        define L = Character('Lily', color="#588ebd")
        define M = Character('Monica', color="#e12421")
        define N = Character('Natasha', color="#a22a10")
        define R = Character('Roger', color="#fda948")
        define S = Character('Sammy', color="#588ebd")
        define W = Character('Wanda', color="#b5287f")
        define X = Character ('????', color="#c8ffc8")
        define Z = Character('Zarah', color="#939941")
        
    ######### Family Matters [Perv2k16] - latest version tested: v1.0
    ## Narrator's name label text color from black to white
    if config.name == "Family Matters":
        define perv = Character('Perv2k16', color="#ffffff")
        define cashier = Character("Cashier", color="#ffffff")
        
    ######### Deeper [Thundorn Games] - latest version tested: v0.0.531
    ## Added outline for the choice button text
    if config.name == "Deeper":
        style choice_button_text:
            outlines [ (absolute(1.5), "#000", absolute(1), absolute(1)) ]
            
    ######### Seraphim Academy [Trinity Games] - latest version tested: Chapter 1
    ## Added outline for the choice button text
    ## Pagekeys disabled in the choice viewport until I can find a better solution to keep older versions of the Ren'Py parser
    ## from crashing on it
    if config.name == "Seraphim Academy":
        style choice_button_text:
            outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
            
        style window:
            background None
    # The next section of code belongs to Trinity Games, it's copied from the game and modified to remove background        
        screen choice(items):
            style_prefix "choice"

            fixed:
                viewport:
                    yinitial 0
                    if choice_screen_show_scrollbar:
                        scrollbars "vertical"
                    mousewheel True
                    draggable True
                    #pagekeys True

                    side_yfill True

                    vbox:
                        for i in items:
                            textbutton i.caption action [SetVariable("choice_screen_show_scrollbar", False), i.action]
                            
    ######### A New Home [Envixer] - the latest version tested: v0.7
    ## Making the the text easier to read in the dialog box by changing the font to Ren'Py default DejaVu Sans.
    if config.name == "A New Home" or config.name == "A New Home v0.7":
        define gui.text_font = "DejaVuSans.ttf"
        define gui.choice_button_text_font = gui.text_font
        
    ######### Babysitter [T4bbo] - the latest version tested: v0.1.4
    ## Replacing large stats button with a small quickmenu-style text button. Replacing thick grey and kinda fuzzy outlines in the dialog box
    ## and name box with my sharp high contrast outlines and making text a bit smaller. Changing default name label color from black to white.
    ## Changing choice menu button outlines to black and insensitive, idle color to white, hover color to green
    if config.name == "Babysitter":
        screen control():
            hbox:
                style_group "quick"
                textbutton ("stats") xpos 0 ypos 0 action If(renpy.get_screen("stat_box"), Hide("stat_box"), Show("stat_box"))
        
        # following code is mostly copied from T4bbo's game and modified
        screen say(who, what, side_image=None, two_window=True):

            # Decide if we want to use the one-window or two-window variant.
            if not two_window:

                # The one window variant.
                window:
                    id "window"

                    has vbox:
                        style "say_vbox"

                    if who:
                        text who id "who"

                    text what id "what"

            else:

                # The two window variant.
                vbox xpos 240:
                    style "say_two_window_vbox"

                    if who:
                        window:
                            style "say_who_window"
                            #xpos -240
                            ypos 155

                            text who:
                                size 20
                                outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
                                xalign 0.5
                                italic True
                                id "who"

                    window:
                        id "window"

                        has vbox:
                            style "say_vbox"

                        text what id "what":
                            outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
                            color "#FFFFFF"
                            size 20

            # If there's a side image, display it above the text.
            if side_image:
                add side_image
            else:
                add SideImage() xalign 0.0 yalign 1.0

            # Use the quick menu.
            use quick_menu
                    
        style quick_button_text:
            is default
            size 14
            
        style say_label:
            color "#FFFFFF"
            
        style menu_choice:
            is default
            color "#FFFFFF"
            idle_color "#FFFFFF"
            hover_color "#00FF00"
            insensitive_color "#808080"
            outlines [ (absolute(2), "#000", absolute(1), absolute(1)) ]
            
    ######### A Wife And Mother [Lust & Passion] - the latest version tested: v0.055
    ## Since the text of every freakin' choice button in the game is colored s-e-p-a-r-a-t-e-l-y to black, it is impossible to override it.
    ## To change that color, the whole script of the game would have to be modified and color tags removed from there. D'oh...
    ## So this is an attempt to be clever and create "active" bright outlines to it. Seems to be working :-P
    if build.name == "A_Wife_And_Mother":
        style choice_button_text:
            idle_outlines [ (absolute(2), "#FFF", absolute(1), absolute(1)) ]
            hover_outlines [ (absolute(2), "#0F0", absolute(1), absolute(1)) ]
            insensitive_outlines [ (absolute(2), "#F00", absolute(1), absolute(1)) ]
            
    ######### Freeloading Family [FFCreation] - the latest version tested: v0.19
    ## Removing fancy text box backgrounds and changing colored outlines of the name labels to patch default
    if config.name == "Freeloading Family":
        define alarm = Character('Alarm' )
        define s = DynamicCharacter("sis_name", image="sister", window_left_margin=0, who_color="#e8004d" )
        define m = Character('You' )
        define mel = Character('Melody', image="melody", window_left_margin=0, who_color="#bd01bd" )
        define dev = Character('Developer', image="dev", window_left_margin=0 )
        define q = Character('???', image="unknown", window_left_margin=0 )
        define l = Character('Leah', image="leah", window_left_margin=0, who_color="#00abd9" )
        define t = Character('Susan', image="susan", window_left_margin=0, who_color="#4e4e4e" )
        define k = Character('Karina', image="karina", window_left_margin=0, who_color="c9c94c"  )
        define gen = Character('The Gentleman', who_color="#8b4513" )
        define h = Character('Hailey', image="hailey", window_left_margin=0, who_color="ec008c" )
        define ev = Character('Everyone' )
        define f = Character('Dad' )
        define c = Character('Customer' )
        define v = Character('Voice' )
        define tv = Character('TV Show' )
        define d = Character('Dean' )
        define r = Character('Clerk' )
        define u = Character('???' )
        define st = Character("", image="sister", what_italic=True, window_left_margin=0, who_color="#e8004d" )
        define led = Character("Leah's Dad")
        define lem = Character("Leah's Mom")
        
    ######### Life with Mary [LikesBlondes] - the latest version tested: v0.27
    ## Removing completely static character side images that are just covering up large part of the screen,
    ## adding nothing to the game. Name label already says who's talking, the image is redundant.
    if config.name == "Life with Mary":
        define p = Character('[player_name]', color="#ff6666")
        define mi = Character('Mike', color="#206be5")
        define m = Character('Mary', color="#f2170c")
        define cl = Character('Clerk', color="#42f4d4")
        define cli = Character('Client', color="#1c3bb5")
        define s = Character('Simone', color="#a7f977")
        define v = Character('Vanessa', color="#53f442")
        define mus = Character('Museum employee', color="#9842f4")
        define ice = Character('Ice rink employee', color="#1d7575")
        define barista = Character('Barista', color="#751d62")
        define andi = Character('Andy', color="#ea0b73")
        define j = Character('John', color="#1c3bb5")
        define carl = Character('Carl', color="#ff6e51")
        define james = Character('James', color="#1c3bb5")
        define gf = Character('[ex_name]', color="#a7f977")
        define w1 = Character('Woman', color="#ff1aff")
        define w2 = Character('Woman', color="#c6538c")

    ######### Pandora's Box [] - the latest version tested: v0.1
    if config.name == "Pandora's Box":
        style say_dialogue:
            font "DejaVuSans.ttf"
            size 32
            color "#FFFFFFFF"
        define gui.text_color = '#FFFFFFFF'
        define gui.interface_text_color = '#FFFFFFFF'

    ######### Haley's story [Viitgames] - the latest version tested: v0.01
    if config.name == "Haleys story":
        style say_dialogue:
            font "DejaVuSans.ttf"
        define p = Character('[player_name]', color="#ff6666")
        define a = Character('Adriana', color="#520575")
        define v = Character('Victor', color="#000b4c")
        define h = Character('Haley', color="#f71b73")
        define d = Character('Diane', color="#f9b300")
        define s = Character('Sandra', color="#f93500")
        define al = Character('Alana', color="#2d9900")
        define hank = Character('Hank', color="#007a99")
        define jim = Character('Jim', color="#7451b5")
        
    ######### [LewdLab] 'Dreams of Desire - The Lost Memories' and 'Midnight Paradise'
    ## Replacing the extra bulky font with Ren'Py's default
    if config.name == "Dreams of Desire - The Lost Memories" or config.name == "Midnight Paradise":
        screen say(who, what):
            style_prefix "say"
            window:
                id "window"
                yoffset 12
                if who is not None:
                    window:
                        id "namebox"
                        style "namebox"
                        text who.upper() id "who" font "DejaVuSans.ttf" size 60 xalign 0.5 yalign 0.5
                text what id "what" font "DejaVuSans.ttf"
                
    ######### The Awakening [SLim Games] - the latest version tested: 0.1
    ## Removing "hardcoded" text box backgrounds and static character side images by redefining characters
    if build.name == "TheAwakening":
        define y = Character("[y1]")
        define m = Character("[m1]")
        define u = Character("???")
        define s = Character("[s1]")
        define l = Character("Linda")
        define f = Character("[f1]")
        define k = Character("Klara B.")
        define p = Character("Mail girl")
        define ma = Character("Margaret")
        define w = Character("Will")
        define c = Character("Cashier")
    
    ######### Big City's Pleasures [Porcus] - the latest version tested: 0.2.2b
    ## Removing "hardcoded" grey color and italic style from the dialog text (italic dialog text
    ## plus quotes around it plus italic character name was marking the thoughts of characters,
    ## this only removes italic from the text, italic names and quotes will remain as they are.
    if config.name == "Big City's Pleasures":
        style say_dialogue:
            size 32
        define t = Character("Tony",color="#0174DF")
        define tt = Character("[t]",color="#0174DF", italic=True, what_italic=True)
        define g = Character("Gina",color="#FE2E64")
        define gg = Character("Gina",color="#FE2E64", italic=True, what_italic=True)
        define j = Character("Jessy",color="#FE642E")
        define jj = Character("Jessy",color="#FE642E", italic=True, what_italic=True)
        define jk = Character("Jacklyn",color="#7F8C8D")
        define jkjk = Character("Jacklyn",color="#7F8C8D", italic=True, what_italic=True)
        define k = Character("Katia",color="#7DCEA0")
        define kk = Character("Katia",color="#7DCEA0", italic=True, what_italic=True)
        define m = Character("Maylin",color="#0E6655")
        define mm = Character("Maylin",color="#0E6655", italic=True, what_italic=True)
        define l = Character("Lian",color="#21618C")
        define ll = Character("Lian",color="#21618C", italic=True, what_italic=True)
        define a = Character("Alexia",color="#D4AC0D")
        define aa = Character("Alexia",color="#D4AC0D", italic=True, what_italic=True)
        define ch = Character("Charlene",color="#D5F5E3")
        define chch = Character("Charlene",color="#D5F5E3", italic=True, what_italic=True)
        define J = Character("Judy",color="#F5CBA7")
        define JJ = Character("Judy",color="#F5CBA7", italic=True, what_italic=True)
        define c = Character("Cassandra",color="#A569BD")
        define cc = Character("Cassandra",color="#A569BD", italic=True, what_italic=True)
        define C = Character("Cassie",color="#A569BD")
        define CC = Character("Cassie",color="#A569BD", italic=True, what_italic=True)
        define w = Character(_("Camarera"),color="#A569BD")
        define ww = Character(_("Camarera"),color="#A569BD", italic=True, what_italic=True)
        define us = Character(_("Secretaria"),color="#A569BD")
        define unkm = Character("...",color="#1E90FF")
        define unkf = Character("...",color="#FF1493")
        define o = Character("Olivia",color="#FFAFA8")
        define oo = Character("Olivia",color="#FFAFA8", italic=True, what_italic=True)
        define r = Character("Rachel",color="#B7950B")
        define rr = Character("Rachel",color="#B7950B", italic=True, what_italic=True)
        define b = Character("Becky",color="#F9EBEA")
        define bb = Character("Becky",color="#F9EBEA", italic=True, what_italic=True)
        define s = Character("Scott",color="#0000b3")
        define ss = Character("Scott",color="#0000b3", italic=True, what_italic=True)
        define S = Character("Sam",color="#CF8942")
        define SS = Character("Sam",color="#CF8942", italic=True, what_italic=True)
        define sab = Character("Sabrina",color="#8A122F")
        define SAB = Character("Sabrina",color="#8A122F", italic=True, what_italic=True)
        define ac = Character(_("Srta. Cooper"),color="#B12D4D") #Addison Cooper
        define acac = Character(_("Srta. Cooper"),color="#B12D4D", italic=True, what_italic=True)
        define doc1 = Character(_("Doctora"),color="#CC0099")
    
    ######### The Personal Assistant [JLCreation] - the latest version tested: v1.0
    ## Character name color from grey to white, removed "Story Teller" character name.
    if build.name == "The_Personal_Assistant":
        style say_label:
            color "#FFF"
        define t = Character("")
    
    ######### Heavy Five [Nottravis] - the latest version tested: Ch 1
    ## Character name color from grey to white, removed "Story Teller" character name.
    if config.name == "Heavy Five":
        $ gui.name_ypos = 20
        $ gui.textbox_height = 200
        $ gui.name_xpos = 20
        $ gui.text_xpos = 100
        $ gui.text_width = 1650
        $ player_fname = "Bob"
        $ player_lname = "Miststück"
        $ b = Character("Becca")
        $ bs = Character("Jane")
        $ mc = Character("You,\n[player_fname]\n[player_lname]")
        $ c = Character("Chris")
        $ s = Character("Sarah")
        $ a = Character("Annie")
        $ k = Character("Kelly")
        $ am = Character("Amanda")
        $ m = Character("Mike")
        $ j = Character("John")
        $ act = Character("Actual")
        $ van = Character("Vanguard")
        $ t = Character("Trish")

    ######### Earth's Sexiest Heroes [Kappuru Games] - the latest version tested: 0.3
    ## Removing character dialog backgrounds
    if config.name == "Earth's Sexiest Heroes":   
        define bw_t = Character("Black Widow Thinking", image="black_widow")
        define ca_t = Character("Captain America Thinking", image="captain_america")
        define nf_t = Character("Nick Fury Thinking", image="nick_fury")
        define mh_t = Character("Maria Hill Thinking", image="maria_hill")
        define fr_mmc = Character("[mmc_default_name]", image="mmc")
        define fr_mmc_t = Character("[mmc_default_name] Thinking", image="mmc")
        define fr_fmc = Character("[name_choice]", image="fmc")
        define fr_fmc_t = Character("[name_choice] Thinking", image="fmc")
        define mr_fmc = Character("[fmc_default_name]", image="fmc")
        define mr_fmc_t = Character("[fmc_default_name] Thinking", image="fmc")
        define mr_mmc = Character("[name_choice]", image="mmc")
        define mr_mmc_t = Character("[name_choice] Thinking", image="mmc")

    ######### Echoes Of Lust [Inceton] - the latest version tested: Ep 3
    ## Narrator font set to Ren'Py default
    if config.name == "EchoesOfLust":
        define n = Character("",what_color="#efd300")
        
    ######### Bad Memories [recreation] - the latest version tested: v0.1
    ## Redefine characters to remove huge fancy name label font, fix name label size and position
    if config.name == "Bad Memories":
        style say_label:
            size 33
            color "#FFF"
        define gui.name_ypos = 50
        define gui.dialogue_xpos = 400
        define gui.name_xpos = 150
        define gui.namebox_width = 200
        define n = Character(None)
        define q = Character(None)
        define name_only = Character(None)
        define pc = Character("[pc_name]", who_color="#2b68b2")
        define pcsure = Character("[pcsure]")
        define pcgender = "[pcgender]"
        define pcthink = Character("[pcthink_name]", who_color="#2b68b2", what_prefix="(", what_suffix=")")
        define e = Character("Ellie")
        define m = Character("[name_m]")
        define j = Character("Jada")
        define t1 = Character("Therapist")
        define t = Character("Katherine")
        define ts = Character("Katie")
        
    ######### Kindread: The Redburns [Inkalicious] - the latest version tested: ch3
    ## Thinking style
    if config.name == "Kindread: The Redburns":
        style thinking:
            color "#ffffff"
            outlines [ (absolute(2), "#00a", absolute(1), absolute(1)) ]
            size style.say_dialogue.size
            
    ######### Babysitters [T4bbo] - the latest version tested: v0.0.1
    ## Replacing large stats button with a small quickmenu-style text button and making dialog text a bit smaller. Changing default name label and dialog text color from black to white. Removing what_outlines from name labels.
    if config.name == "Babysitters":
        define mik = DynamicCharacter("player_name", color="#1e90ff")
        define ton = Character("Tony", color = "#ffddff")
        define eri = Character('Erica', color="#ff69b4")
        define jes = Character('Jessica', color="#FF0000")
        define lar = Character('Lara', color="#8b0000")
        define jon = Character('John', color="#bc8f8f")
        define wic = Character('Dr. Wick', color = "#fff")
        define sas = Character('Sasha', color="#9370db")
        define jan = Character('Jane', color = "f1f442")
        define mir = Character('Miranda', color = "2a075b")
        define ang = Character('Angelica', color = "#5b3007")
        define xxx = Character('Uknown person', color = "#fff")
        # say dialogue
        screen say(who, what):
            vbox:
                yalign 0.999
                if who:
                    frame:
                        ypos 94
                        ymaximum 88
                        yminimum 88                        
                        xminimum 380
                        xmaximum 380
                        xpos 8
                        background None
                        text who id "who" xalign 0.5 color "#FFFFFF"
                frame:    
                    ysize 150
                    xanchor -0.25
                    xmaximum 1520
                    xminimum 1520  
                    xpadding 125
                    background None
                    text what id "what" xpos -25 yalign 0.45 xmaximum 2150 color "#FFFFFF" size 29
            # Use the quick menu.
            use quick_menu
                    
        style window:
            xalign 0.5
            xfill True
            yalign gui.textbox_yalign
            ysize gui.textbox_height
            variant "small"

        style namebox:
            xpos gui.name_xpos
            xanchor gui.name_xalign
            xsize gui.namebox_width
            ypos 23
            ysize gui.namebox_height
            padding gui.namebox_borders.padding
            
        style quick_button_text:
            is default
            size 14
            
        screen control():
            vbox:
                style_prefix "quick"
                textbutton _("Stats") xpos 0 ypos 0 action If(renpy.get_screen("stat_box"), Hide("stat_box"), Show("stat_box"))

    ######### The Way [Zee95] - v0.23a
    ## Removing character dialog styles to apply the style of this patch
    if config.name == "The Way":
        define z = DynamicCharacter("p_name", image = "mc", screen = "say" )
        define s = Character("", screen = "say" )
        define jan = Character("Janet", image = "jan", screen = "say" )
        define ade = Character("Adele", image = "ade", screen = "say")
        define tyr = Character("Tyron", image = "tyr", screen = "say")
        define ang = Character("Angelina", image = "ang", screen = "say")
        define msj = Character("Mrs.Jonas", image = "msj", screen = "say")
        define mse = Character("Miss Estevez", image = "mse", screen = "say")
        define pao = Character("Paola", image = "paola", screen = "say")
        define fran = Character("Frank", image = "fran", screen = "say")
        define ram = Character("Ramon", image = "ram", screen = "say")
        define hen = Character("Henry", image = "hen", screen = "say")
        define carlos = Character("Carlos", image = "carlos", screen = "say")
        define sonya = Character("Sonya", image = "sonya", screen = "say")
        define melis = Character("Melissa", image = "melis", screen = "say")
        define alisha = Character("Alisha", image = "alisha", screen = "say")
        define moniq = Character("Monique", image = "moniq", screen = "say")
        define strn = Character("Stranger", image = "strn", screen = "say")
        define anna = Character("Anna", image = "anna", screen = "say")
        define deb = Character("Debby", image = "deb", screen = "say")
        define est = Character("Estelle", image = "est", screen = "say")
        define girl = Character("Girl", image = "strn", screen = "say")
        define man = Character("Man", image = "strn", screen = "say")
        define mat = Character("Matt", image = "mat", screen = "say")
        define alis = Character("Alice", image = "alis", screen = "say")
        define sec = Character("Security guard", image = "strn", screen = "say")
        define cop = Character("Cop", image = "strn", screen = "say")
        define wom = Character("Women", image = "strn", screen = "say")
        define john = Character("John The Maniac", image = "strn", screen = "say")
        define jm = Character("John's mom", image = "strn", screen = "say")
        define girl = Character("Girl", image = "strn", screen = "say")
        define raf = Character("Rafiq", image = "raf", screen = "say")
        define jol = Character("Joulia", image = "jol", screen = "say")
        define seb = Character("Sebastian", image = "seb", screen = "say")
        define lis = Character("Lisa", image = "lis", screen = "say")
        define vic = Character("Victoria", image = "vic", screen = "say")
        define nurs = Character("Nurse", image = "strn", screen = "say")
        define pat = Character("Patrick", image = "pat", screen = "say")
        define bat = Character("Batty", image = "bat", screen = "say")
        define dag = Character("Doug", image = "dag", screen = "say")
        define mar = Character("Maria", image = "mar", screen = "say")
        define wai = Character("Waiter", image = "strn", screen = "say")
        define vinc = Character("Vincent", image = "vinc", screen = "say")
        define osc = Character("Oscar", image = "osc", screen = "say")

    ######### Forgotten Paradise [Void Star] - v0.12
    ## Removing character dialog styles to apply the style of this patch
    if config.name == "Forgotten Paradise":
        define mc = Character("[player_name]", color = "#85B200",  image = "mc") 
        define ad = Character("[alien_daughter]", color = "#F1DDF7",  image = "ad") 
        define voidstar = Character("Void Star", color = "#FFFFFF", image = "voidstar") 
        define alex = Character("Alex", color = "#FFFFFF", image = "alex") 
        define qm = Character("???", color = "#FFFFFF", image = "qm") 
        define ivy = Character("Ivy", color = "#822100", image = "ivy") 
        define ingrid = Character("Ingrid", color = "#624720", image = "ingrid") 
        define mira = Character("Mira", color = "#55332B", image = "mira") 
        define luna = Character("Luna", color = "#CACAD9", image = "luna") 
        define dany = Character("Dany", color = "#F5E483", image = "dany") 
        define ramsay = Character("Ramsay", color = "#C2C2BA", image = "ramsay") 
        define r = Character("Ruby", color = "#FF9999", image = "ruby") 
        define z = Character("Zoey", color = "#DFBFFF", image = "zoey") 
        define jack = Character("Jack", color = "#999999", image="jack") 
        define e = Character("Elyse", color = "#4DFFA6", image = "elyse") 
        define j = Character("Jane", color = "#007095", image = "jane") 
        define a = Character("Andre", color = "#FFFF00", image = "andre") 
        define edis = Character("Edis", color = "#F34E52", image = "edis") 
        define amir = Character("Amir", color = "#B25900", image = "amir") 
        define d = Character("Dahlia", color = "#FF2626", image = "dahlia") 
        define shp = Character("Karin", color = "#8C0000", image = "karin") 
        define aur = Character("Aurora", color = "#486DA2", image = "aurora") 
        define l = Character("Lexa", color = "#008C00", image = "lexa") 
        define chloe = Character("Chloe", color = "#006DD9", image = "chloe") 
        define m = Character("Melisa", color = "#FFC926", image = "melisa") 
        define v = Character("Victor", color = "#BFFFDF", image = "victor") 
        define cass = Character("Cassandra", color = "#A64DFF", image="cass")

    ######### Primal Instinct [SilkandMilkProductions] - v0.03 
    ## Removing character dialog styles to apply the style of this patch       
    if build.name == "PrimalInstinct":        
        define mc = Character("[mc]")
        define s = Character('Sandra')
        define a = Character("Alex")
        define b = Character("Blake")
        define m = Character("Meghan")
        define u = Character("???")
        define me = Character("Mei" )
        define lw = Character("Lawan")
        define n = Character("Mr. Novak")
        define mi = Character("Misha")

    ######### Estate: Dominate [Henissart] - v0.17 R2
    ## Removing dark grey colors from character labels
    if config.name == "Estate : Dominate":
        define vic = Character(("Victor"))
        define driver = Character(("Driver"))
        define uvoice = Character(("Voice"))
        style quick_button_text:
            size 24
        screen say(who, what):
            style_prefix "say"
            window:
                id "window"
                if who is not None:
                    window:
                        id "namebox"
                        style "namebox"
                        text who id "who"
                text what id "what"
            if not renpy.variant("small"):
                add SideImage() xalign 0.0 yalign 1.0
            use quick_menu

    ######### Gates Motel [P_S_Y_C_H_O] - v0.3b
    ## Removing colors from character dialog text
    if config.name == "Gates Motel":
        define dev = Character("PSYCHO", who_color= "#4e4c4b")
        define unknown = Character("?????", who_color="#c5c6c4")
        define m = Character("[mc]", who_color="#FFFFFF")
        define n = Character("[no]", who_color="#0099ff")
        define g = Character("[gr]", who_color="#a4fd00")
        define a = Character("[al]", who_color="#fe8aff")
        define r = Character("[ro]", who_color="#7f0004")
        define savage = Character("Savage", who_color="#c98929")
        define s = Character("[sa]", who_color="#c98929")

            
# Python init section
init 999 python:
    
    # code inspired by bossapplesauce
    if config.name == "Indecent Desires":
        hardcoded = {}

        def rm_bold(text):
            def text_repl(t):
                if t.group(0).startswith("\{b\}"): return ""
                elif t.group(0).startswith("\{\/b\}"): return ""
            return hardcoded[text] if text in hardcoded else renpy.re.sub( r'(?:\{b\}|\{\/b\})', text_repl, text )

        config.say_menu_text_filter = rm_bold
    
    ######### Parental Love [Luxee] - the latest version tested: v0.6
    ## Overriding outline settings forced via init python and not by redefining styles
    if config.name == "Parental Love":
        renpy.register_style_preference("text", "decorated", style.say_dialogue, "outlines", [ (2, "#000", 1, 1) ])
        renpy.register_style_preference("text", "decorated", style.say_label, "outlines", [ (2, "#000", 1, 1) ])

    ######### Babysitter [T4bbo] - the latest version tested: v0.1.4
    ## Removing text box and menu button backgrounds, making custom "thought" tag color brighter
    if config.name == "Babysitter" or config.name == "Babysitters":
        style.say_who_window.background = None
        style.menu_choice_button.background = None
        style.menu_choice_button.hover_background = None
        # following code is copied from T4bbo's game and modified
        def my_tag(tag, argument, contents):
            return [
                (renpy.TEXT_TAG, u"i"),
                (renpy.TEXT_TAG, u"color=#a2b6ff"), #1a4aff
            ] + contents + [
                (renpy.TEXT_TAG, u"/color"),
                (renpy.TEXT_TAG, u"/i"),
            ]
        config.custom_text_tags["t"] = my_tag
